package com.siguiente.fasal.firebase


import android.app.NotificationChannel
import android.app.NotificationManager
import android.content.Context
import android.content.Intent
import android.content.Intent.FLAG_ACTIVITY_NEW_TASK
import android.os.Build
import android.util.Log
import androidx.core.app.NotificationCompat
import androidx.core.app.NotificationManagerCompat
import androidx.core.content.ContextCompat
import com.google.firebase.messaging.FirebaseMessagingService
import com.google.firebase.messaging.RemoteMessage
import com.siguiente.fasal.R
import com.siguiente.fasal.utils.PreferenceProvider
import com.siguiente.fasal.videos.IncomingCallScreenActivity
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance
import kotlin.random.Random

class MyFirebaseMessagingService : FirebaseMessagingService(), KodeinAware {
    override val kodein by kodein()
    val provider: PreferenceProvider by instance()
    override fun onMessageReceived(p0: RemoteMessage) {

        Log.d(TAG, "From: ${p0.from}")
        // Check if message contains a data payload.
        p0.data.let {
            Log.d(TAG, "Message data payload: " + p0.data)
            if (it["type"].toString() == "Calling") {
                val intent = Intent(applicationContext,IncomingCallScreenActivity::class.java)
                intent.putExtra("callingToken",it["callingToken"])
                intent.putExtra("callerName",it["title"])
                intent.flags = FLAG_ACTIVITY_NEW_TASK
                startActivity(intent)
            }else{
                showNotification(it)
            }
        }

        /*    // Check if message contains a notification payload.
            p0.notification?.let {
                Log.d(TAG, "Message Notification Body: ${it.body}")
                sendNotification(it.body!!)
            }*/
    }

    override fun onNewToken(p0: String) {
        Log.d(TAG, "Refreshed token: $p0")
        provider.saveValueByKey("firebaseToken", "" + p0)
        // sendRegistrationToServer(p0)
    }


    private fun sendNotification(messageBody: Map<String,String>) {
        val notificationManager = ContextCompat.getSystemService(
            applicationContext,
            NotificationManager::class.java
        ) as NotificationManager
        notificationManager.sendNotification(messageBody, applicationContext)
    }

    private fun showNotification(data:Map<String,String>) {
        val builder = NotificationCompat.Builder(this, channelID)
            .setSmallIcon(R.drawable.logout)
            .setContentTitle(data["title"])
            .setStyle(
                NotificationCompat.BigTextStyle()
                    .bigText(data["description"])
            )
            .setPriority(NotificationCompat.PRIORITY_DEFAULT)
        val notificationManager: NotificationManager = getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val name = getString(R.string.app_name)
            val descriptionText = getString(R.string.app_name)
            val importance = NotificationManager.IMPORTANCE_DEFAULT
            val channel = NotificationChannel(channelID, name, importance).apply {
                description = descriptionText
            }
            notificationManager.createNotificationChannel(channel)
        }

        val notificationID = (0..10).random()
        with(NotificationManagerCompat.from(this)) {
            notify(notificationID, builder.build())
        }

    }



    companion object {
        private const val TAG = "MyFirebaseMsgService"
        private const val channelID = "Kishan Channel"
    }

}