package com.siguiente.fasal.firebase

import android.app.NotificationManager
import android.app.PendingIntent
import android.content.Context
import android.content.Intent
import android.graphics.BitmapFactory
import androidx.core.app.NotificationCompat
import com.siguiente.fasal.MainActivity
import com.siguiente.fasal.R
import com.siguiente.fasal.receiver.SnoozeReceiver
import com.siguiente.fasal.videos.IncomingCallScreenActivity

// Notification ID.
private val NOTIFICATION_ID = 0
private val REQUEST_CODE = 0
private val FLAGS = 0


fun NotificationManager.sendNotification(messageBody:Map<String,String>, applicationContext: Context) {



    val contentIntent = Intent(applicationContext, IncomingCallScreenActivity::class.java)


    val contentPendingIntent = PendingIntent.getActivity(
        applicationContext,
        NOTIFICATION_ID,
        contentIntent,
        PendingIntent.FLAG_UPDATE_CURRENT
    )


    val eggImage = BitmapFactory.decodeResource(
        applicationContext.resources,
        R.drawable.logout
    )
    val bigPicStyle = NotificationCompat.BigPictureStyle()
        .bigPicture(eggImage)
        .bigLargeIcon(null)


    val snoozeIntent = Intent(applicationContext, SnoozeReceiver::class.java)
    val snoozePendingIntent: PendingIntent =
        PendingIntent.getBroadcast(applicationContext, REQUEST_CODE, snoozeIntent, FLAGS)

    // Build the notification
    val builder = NotificationCompat.Builder(
        applicationContext,
        "Fasal Channel")
        .setSmallIcon(R.drawable.logout)
        .setContentTitle(messageBody["title"])
        .setContentText(messageBody["title"])
        .setContentIntent(contentPendingIntent)
        .setStyle(bigPicStyle)
        .setLargeIcon(eggImage)
        .addAction(
            R.drawable.ic_mobile_icon,
            "close",
            snoozePendingIntent
        )
        .setPriority(NotificationCompat.PRIORITY_HIGH)
        .setAutoCancel(true)

    notify(NOTIFICATION_ID, builder.build())
}


fun NotificationManager.cancelNotifications() {
    cancelAll()
}