package com.siguiente.fasal.help

import android.app.Activity
import android.content.Intent
import android.content.pm.PackageManager
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.net.Uri
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.os.Environment
import android.provider.MediaStore
import android.util.Base64
import android.util.Log
import android.view.View
import android.widget.Toast
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import androidx.core.content.FileProvider
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.bumptech.glide.Glide
import com.siguiente.fasal.BuildConfig
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivityQuestionBinding
import com.siguiente.fasal.dialog.MessageDialog
import com.siguiente.fasal.home.HomeViewModel
import com.siguiente.fasal.home.HomeViewModelFactory
import com.siguiente.fasal.home.model.CategoryModel
import com.siguiente.fasal.my_store.MyStoreViewModel
import com.siguiente.fasal.my_store.StoreViewModelFactory
import com.siguiente.fasal.my_store.model.SubCategoryModel
import com.siguiente.fasal.utils.*
import kotlinx.android.synthetic.main.activity_question.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance
import java.io.ByteArrayOutputStream
import java.io.File
import java.io.FileInputStream
import java.io.IOException
import java.text.SimpleDateFormat
import java.util.*
import kotlin.collections.ArrayList

class QuestionActivity : AppCompatActivity(), KodeinAware, SpinnerExtensions.ItemSelectedListener,
    View.OnClickListener {
    override val kodein by kodein()
    lateinit var binding: ActivityQuestionBinding

    private lateinit var homeViewModel: HomeViewModel
    private val factoryHome: HomeViewModelFactory by instance()
    private lateinit var storeViewModel: MyStoreViewModel
    private val factoryStore: StoreViewModelFactory by instance()
    private val subCategoryArray = ArrayList<SubCategoryModel>()
    val provider: PreferenceProvider by instance()
    private var categoryID = ""
    private var subCategoryID = ""
    private var categoryName = ""
    private var subCategoryName = ""
    private var base64ImageOne = ""
    private var base64ImageTwo = ""
    private var base64ImageThree = ""
    private var base64ImageFour = ""
    private var currentPhotoPath: String =""

    lateinit var viewModel: ServiceViewModel
    val factory: ServiceViewModelFactory by instance()
    private var serviceID = ""
    private var serviceType = ""


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_question)

        serviceID = intent.extras!!.getString("serviceID", "")
        serviceType = intent.extras!!.getString("serviceType", "")

        homeViewModel = ViewModelProvider(this, factoryHome).get(HomeViewModel::class.java)
        homeViewModel.getCategories()
        storeViewModel = ViewModelProvider(this, factoryStore).get(MyStoreViewModel::class.java)
        viewModel = ViewModelProvider(this, factory).get(ServiceViewModel::class.java)

        viewModel.result.observe(this, Observer {
            questionProgressBar.visibility = View.GONE
            val dialog = MessageDialog(it.message!!)
            dialog.show(supportFragmentManager,"MessageDialog")
        })

        subCategoryArray.add(
            SubCategoryModel(
                "0",
                "0",
                "No Subcategory Found",
                "",
                "",
                "",
                "",
                "",
                ""
            )
        )

        homeViewModel.result.observe(this, Observer {
            seedCategorySpinnerQ.setEntries(it.data)
        })

        storeViewModel.subCategoryResult.observe(this, Observer {
            if (!it.error!!)
                seedSubCategorySpinnerQ.setSubCategoryData(it.data)
            else
                seedSubCategorySpinnerQ.setSubCategoryData(subCategoryArray)
        })


        seedCategorySpinnerQ.setItemSelectedListener(this)
        seedSubCategorySpinnerQ.setSubItemSelectedListener(this)

        fasalImageOneIV.setOnClickListener(this)
        fasalImageTwoIV.setOnClickListener(this)
        fasalImageThreeIV.setOnClickListener(this)
        fasalImageFourIV.setOnClickListener(this)

        addQuestionBackIV.setOnClickListener {
            onBackPressed()
        }
        sendQuestionButton.setOnClickListener {
            questionProgressBar.visibility = View.VISIBLE
            serviceRequest()
        }

    }

    private fun serviceRequest() {
        val map: HashMap<String, String> = HashMap()
        val userID = provider.getValueByKey("userID")
        map["userID"] = userID!!
        map["serviceID"] = serviceID
        map["serviceType"] = serviceType
        map["categoryName"] = categoryName
        map["subCategoryName"] = subCategoryName
        map["fasalProblem"] = fasalDescriptionET.text.toString()
        map["imageOne"] = base64ImageOne
        map["imageTwo"] = base64ImageTwo
        map["imageThree"] = base64ImageThree
        map["imageFour"] = base64ImageFour
        viewModel.sendServiceRequest(map)
    }


    private fun selectImageDialog(cameraCode: Int, galleryCode: Int) {
        val options = arrayOf<CharSequence>("Take Photo", "Choose from Gallery", "Cancel")
        val builder = androidx.appcompat.app.AlertDialog.Builder(this)
        builder.setTitle("Choose your Document Picture")

        builder.setItems(options) { dialog, item ->
            if (options[item] == "Take Photo") {
                val checkSelfPermission =
                    ContextCompat.checkSelfPermission(
                        this,
                        android.Manifest.permission.CAMERA
                    )
                if (checkSelfPermission != PackageManager.PERMISSION_GRANTED) {
                    ActivityCompat.requestPermissions(
                        this,
                        arrayOf(android.Manifest.permission.CAMERA),
                        1
                    )
                } else {
                    dispatchTakePictureIntent(cameraCode)
                }

            } else if (options[item] == "Choose from Gallery") {
                val checkSelfPermission = ContextCompat.checkSelfPermission(
                    this,
                    android.Manifest.permission.WRITE_EXTERNAL_STORAGE
                )
                if (checkSelfPermission != PackageManager.PERMISSION_GRANTED) {
                    ActivityCompat.requestPermissions(
                        this,
                        arrayOf(android.Manifest.permission.WRITE_EXTERNAL_STORAGE),
                        1
                    )
                } else {
                    val pickPhoto = Intent(
                        Intent.ACTION_PICK,
                        MediaStore.Images.Media.EXTERNAL_CONTENT_URI
                    )
                    startActivityForResult(pickPhoto, galleryCode)
                }

            } else if (options[item] == "Cancel") {
                dialog.dismiss()
            }
        }
        builder.show()

    }

    @Throws(IOException::class)
    private fun createImageFile(): File {
        val timeStamp: String = SimpleDateFormat("yyyyMMdd_HHmmss").format(Date())
        val storageDir: File? = getExternalFilesDir(Environment.DIRECTORY_PICTURES)
        return File.createTempFile(
            "JPEG_${timeStamp}_", /* prefix */
            ".jpg", /* suffix */
            storageDir /* directory */
        ).apply {
            currentPhotoPath = absolutePath
        }
    }


    private fun dispatchTakePictureIntent(requestCode: Int) {
        Intent(MediaStore.ACTION_IMAGE_CAPTURE).also { takePictureIntent ->
            takePictureIntent.resolveActivity(packageManager)?.also {
                val photoFile: File? = try {
                    createImageFile()
                } catch (ex: IOException) {
                    null
                }
                photoFile?.also {
                    val photoURI: Uri = FileProvider.getUriForFile(
                        this,
                        BuildConfig.APPLICATION_ID + ".fileprovider",
                        it
                    )
                    takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT, photoURI)
                    startActivityForResult(takePictureIntent, requestCode)
                }
            }
        }
    }


    override fun onRequestPermissionsResult(
        requestCode: Int,
        permissions: Array<out String>,
        grantResults: IntArray
    ) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults)
        when (requestCode) {
            1 ->
                if (grantResults.isNotEmpty() && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    selectImageDialog(101, 102)
                } else {
                    Toast.makeText(this, "You denied the permission", Toast.LENGTH_SHORT).show()
                }
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        when (requestCode) {
            101 ->
                if (resultCode == Activity.RESULT_OK) {
                    val imageBitmap = data?.extras?.get("data")
                    Glide.with(this).load(currentPhotoPath).into(fasalImageOneIV)
                    Log.e("ImageBitmapData-", "" + imageBitmap)
                    Log.e("ImagePath-", "" + currentPhotoPath)
                    val file = File(currentPhotoPath)
                    val b = BitmapFactory.decodeStream(FileInputStream(file))
                    base64ImageOne = toBase64(b)!!
                }
            102 ->
                if (resultCode == Activity.RESULT_OK) {
                    Glide.with(this).load(currentPhotoPath).into(fasalImageTwoIV)
                    val file = File(currentPhotoPath)
                    val b = BitmapFactory.decodeStream(FileInputStream(file))
                    base64ImageTwo = toBase64(b)!!
                }
            103 ->
                if (resultCode == Activity.RESULT_OK) {
                    Glide.with(this).load(currentPhotoPath).into(fasalImageThreeIV)
                    val file = File(currentPhotoPath)
                    val b = BitmapFactory.decodeStream(FileInputStream(file))
                    base64ImageThree = toBase64(b)!!
                }
            104 ->
                if (resultCode == Activity.RESULT_OK) {
                    Glide.with(this).load(currentPhotoPath).into(fasalImageFourIV)
                    val file = File(currentPhotoPath)
                    val b = BitmapFactory.decodeStream(FileInputStream(file))
                    base64ImageFour = toBase64(b)!!

                }
            201 ->
                if (resultCode == Activity.RESULT_OK) {
                    val imageUri: Uri = data?.data!!
                    var bitmap: Bitmap? = null
                    try {
                        bitmap =
                            MediaStore.Images.Media.getBitmap(contentResolver, imageUri)
                        fasalImageOneIV.setImageBitmap(bitmap)
                    } catch (e: IOException) {
                        e.printStackTrace()
                    }
                    base64ImageOne = toBase64(bitmap!!)!!
                }
            202 ->
                if (resultCode == Activity.RESULT_OK) {
                    val imageUri: Uri = data?.data!!
                    var bitmap: Bitmap? = null
                    try {
                        bitmap =
                            MediaStore.Images.Media.getBitmap(contentResolver, imageUri)
                        fasalImageTwoIV.setImageBitmap(bitmap)
                    } catch (e: IOException) {
                        e.printStackTrace()
                    }
                    base64ImageTwo = toBase64(bitmap!!)!!
                }
            203 ->
                if (resultCode == Activity.RESULT_OK) {
                    val imageUri: Uri = data?.data!!
                    var bitmap: Bitmap? = null
                    try {
                        bitmap =
                            MediaStore.Images.Media.getBitmap(contentResolver, imageUri)
                        fasalImageThreeIV.setImageBitmap(bitmap)
                    } catch (e: IOException) {
                        e.printStackTrace()
                    }
                    base64ImageThree = toBase64(bitmap!!)!!
                }
            204 ->
                if (resultCode == Activity.RESULT_OK) {
                    val imageUri: Uri = data?.data!!
                    var bitmap: Bitmap? = null
                    try {
                        bitmap =
                            MediaStore.Images.Media.getBitmap(contentResolver, imageUri)
                        fasalImageFourIV.setImageBitmap(bitmap)
                    } catch (e: IOException) {
                        e.printStackTrace()
                    }
                    base64ImageFour = toBase64(bitmap!!)!!
                }
        }

    }

    fun toBase64(bm: Bitmap): String? {
        val baos = ByteArrayOutputStream()
        bm.compress(Bitmap.CompressFormat.PNG, 100, baos) //bm is the bitmap object
        val b: ByteArray = baos.toByteArray()
        return Base64.encodeToString(b, Base64.NO_WRAP)
    }

    override fun onItemSelected(item: CategoryModel) {
        categoryID = item.categoryID
        categoryName = item.categoryName
        Log.e("Selected Item-", "" + item.categoryID)
        val map: java.util.HashMap<String, String> = java.util.HashMap()
        map["categoryID"] = categoryID
        storeViewModel.getSubCategories(map)
    }

    override fun onSubItemSelected(item: SubCategoryModel) {
        subCategoryID = item.id
        subCategoryName = item.subCategoryName
        Log.e("Selected  Sub Item-", "" + item.id)
    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.fasalImageOneIV -> {
                selectImageDialog(101, 201)
            }
            R.id.fasalImageTwoIV -> {
                selectImageDialog(102, 202)
            }
            R.id.fasalImageThreeIV -> {
                selectImageDialog(103, 203)
            }
            R.id.fasalImageFourIV -> {
                selectImageDialog(104, 204)
            }
        }
    }
}