package com.siguiente.fasal.help

import com.siguiente.fasal.network.MyApi
import com.siguiente.fasal.network.SafeApiRequest
import com.siguiente.fasal.network.response.*

class ServiceRepository(
    private val api: MyApi
) : SafeApiRequest() {

    suspend fun getServices(): ServiceResponse {
        return apiRequest { api.getServices() }
    }

    suspend fun getServiceRequestList(field: HashMap<String, String>): ServiceRequestListResponse {
        return apiRequest { api.getServiceRequestList(field) }
    }

    suspend fun sendServiceRequest(field: HashMap<String, String>): CommonResponse {
        return apiRequest { api.sendServiceRequest(field) }
    }

    suspend fun sendServicePayment(field: HashMap<String, String>): CommonResponse {
        return apiRequest { api.sendServiceRequest(field) }
    }

    suspend fun viewQuestion(filed: Map<String, String>): ViewQuestionResponse {
        return apiRequest {
            api.viewServiceRequestDetail(filed)
        }
    }

    suspend fun getServiceRequestReply(filed: Map<String, String>): AnswerResponse {
        return apiRequest {
            api.getServiceRequestReply(filed)
        }
    }
}