package com.siguiente.fasal.help

import android.util.Log
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasal.network.response.*
import com.siguiente.fasal.utils.ApiException
import com.siguiente.fasal.utils.Coroutines
import com.siguiente.fasal.utils.NoInternetException

class ServiceViewModel(
    val repository: ServiceRepository
) : ViewModel() {

    var result = MutableLiveData<CommonResponse>()
    var serviceResult = MutableLiveData<ServiceResponse>()
    var serviceRequestResult = MutableLiveData<ServiceRequestListResponse>()
    val viewQuestionResult = MutableLiveData<ViewQuestionResponse>()
    val viewServiceRequestReplyResult = MutableLiveData<AnswerResponse>()

    fun getServices() {
        Coroutines.main {
            try {
                val response = repository.getServices()
                Log.e("GetServices -", "" + response.toString())
                serviceResult.value = response

            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun getServiceRequestList(field: HashMap<String, String>) {
        Coroutines.main {
            try {
                val response = repository.getServiceRequestList(field)
                Log.e("GetServicesReqList -", "" + response.toString())
                serviceRequestResult.value = response

            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun sendServiceRequest(field: HashMap<String, String>) {
        Coroutines.main {
            try {
                val response = repository.sendServiceRequest(field)
                Log.e("SendServiceReq -", "" + response.toString())
                result.value = response

            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }


    fun sendServicePayment(field: HashMap<String, String>) {
        Coroutines.main {
            try {
                val response = repository.sendServicePayment(field)
                Log.e("SendServicePayment -", "" + response.toString())
                result.value = response

            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun viewQuestion(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.viewQuestion(field)
                viewQuestionResult.value = response
                Log.e("viewQuestionResult", "" + response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }


    fun viewServiceRequestReply(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.getServiceRequestReply(field)
                viewServiceRequestReplyResult.value = response
                Log.e("viewServRequestReResult", "" + response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

}