package com.siguiente.fasal.help

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import androidx.databinding.DataBindingUtil
import androidx.viewpager.widget.ViewPager
import com.google.android.material.tabs.TabLayout
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivitySupportBinding
import com.siguiente.fasal.help.adapter.ServicePagerAdapter
import com.siguiente.fasal.help.fragment.ScheduleMeetingFragment
import com.siguiente.fasal.help.fragment.ServiceFragment
import com.siguiente.fasal.utils.PreferenceProvider
import kotlinx.android.synthetic.main.activity_support.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance

class SupportActivity : AppCompatActivity(), KodeinAware {

    override val kodein by kodein()
    val provider: PreferenceProvider by instance()
    lateinit var binding: ActivitySupportBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_support)
        supportActionBar?.hide()

        setStatePageAdapter()

        supportBackIV.setOnClickListener {
            onBackPressed()
        }

    }

    private fun setStatePageAdapter() {
        val viewPager: ViewPager = findViewById(R.id.helpAndSupportViewPager)
        val tabs: TabLayout = findViewById(R.id.tabsHepAndSupport)
        val userType = provider.getValueByKey("userType")!!
        val sectionsPagerAdapter = ServicePagerAdapter(supportFragmentManager)
        sectionsPagerAdapter.addFragment(ServiceFragment(), "Services")
        sectionsPagerAdapter.addFragment(ScheduleMeetingFragment(), "Scheduled Meeting")
        viewPager.adapter = sectionsPagerAdapter
        tabs.setupWithViewPager(viewPager)

    }
}