package com.siguiente.fasal.help

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.MenuItem
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivityViewAnswerBinding
import com.siguiente.fasal.help.adapter.AnswerAdapter
import com.siguiente.fasal.help.model.AnswerModel
import com.siguiente.fasal.network.response.ViewQuestionResponse
import com.siguiente.fasal.utils.PreferenceProvider
import kotlinx.android.synthetic.main.activity_view_answer.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance
import java.util.HashMap

class ViewAnswerActivity : AppCompatActivity(), KodeinAware {
    override val kodein by kodein()
    lateinit var binding: ActivityViewAnswerBinding

    lateinit var viewModel: ServiceViewModel
    val factory: ServiceViewModelFactory by instance()
    val provider: PreferenceProvider by instance()

    lateinit var responseModel: ViewQuestionResponse
    private var serviceRequestID = ""


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_view_answer)
        serviceRequestID = intent.extras!!.getString("serviceRequestID", "")
        viewModel = ViewModelProvider(this, factory).get(ServiceViewModel::class.java)

        viewQuestion()
        getAnswer()

        viewModel.viewQuestionResult.observe(this, Observer {
            if (!it.error!!) {
                binding.viewQuestionModel = it
                responseModel = it
            }
        })

        viewModel.viewServiceRequestReplyResult.observe(this, Observer {
            if (!it.error!!) {
                initAnswerRecyclerView(it.data!!)
            } else {
                answerRecyclerView.apply {
                    adapter = null
                }
            }
        })

        answerBackIV.setOnClickListener {
            onBackPressed()
        }

    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        return when (item.itemId) {
            android.R.id.home -> {
                onBackPressed()
                true
            }
            else -> super.onOptionsItemSelected(item)
        }
    }


    private fun initAnswerRecyclerView(arrayList: ArrayList<AnswerModel>) {
        val answerAdapter = AnswerAdapter().apply {
            addItems(arrayList)
        }
        answerRecyclerView.apply {
            adapter = answerAdapter
        }
    }


    private fun viewQuestion() {
        val map: HashMap<String, String> = HashMap()
        map["serviceRequestID"] = serviceRequestID
        viewModel.viewQuestion(map)
    }


    private fun getAnswer() {
        val map: HashMap<String, String> = HashMap()
        map["serviceRequestID"] = serviceRequestID
        viewModel.viewServiceRequestReply(map)
    }

}