package com.siguiente.fasal.help.adapter

import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ScheduleMeetingItemDesignBinding
import com.siguiente.fasal.help.model.ServiceRequestListModel
import com.siguiente.fasal.utils.BaseRecyclerViewAdapter

class ScheduledMeetingAdapter :
    BaseRecyclerViewAdapter<ServiceRequestListModel, ScheduleMeetingItemDesignBinding>() {
    override fun getLayout() = R.layout.schedule_meeting_item_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<ScheduleMeetingItemDesignBinding>,
        position: Int
    ) {
        holder.binding.serviceRequestModel = items[position]
        holder.binding.viewAnswerLinearLayout.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

    }

}