package com.siguiente.fasal.help.adapter

import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ServiceItemDesignBinding
import com.siguiente.fasal.help.model.ServiceModel
import com.siguiente.fasal.utils.BaseRecyclerViewAdapter

class ServiceAdapter : BaseRecyclerViewAdapter<ServiceModel, ServiceItemDesignBinding>() {
    override fun getLayout() = R.layout.service_item_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<ServiceItemDesignBinding>,
        position: Int
    ) {
        holder.binding.serviceModel = items[position]
        holder.binding.scheduleRequestButton.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

    }

}