package com.siguiente.fasal.help.fragment

import android.content.Intent
import android.os.Bundle
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.FragmentScheduleMeetingBinding
import com.siguiente.fasal.help.ServiceViewModel
import com.siguiente.fasal.help.ServiceViewModelFactory
import com.siguiente.fasal.help.ViewAnswerActivity
import com.siguiente.fasal.help.adapter.ScheduledMeetingAdapter
import com.siguiente.fasal.help.model.ServiceRequestListModel
import com.siguiente.fasal.my_store.AddProductActivity
import com.siguiente.fasal.utils.PreferenceProvider
import kotlinx.android.synthetic.main.fragment_schedule_meeting.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance
import java.util.HashMap

class ScheduleMeetingFragment : Fragment(), KodeinAware {
    override val kodein by kodein()
    lateinit var binding: FragmentScheduleMeetingBinding
    lateinit var viewModel: ServiceViewModel
    val factory: ServiceViewModelFactory by instance()
    val provider: PreferenceProvider by instance()


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        binding =
            DataBindingUtil.inflate(inflater, R.layout.fragment_schedule_meeting, container, false)


        return binding.root
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)

        viewModel = ViewModelProvider(this, factory).get(ServiceViewModel::class.java)
        val userID = provider.getValueByKey("userID")
        val map: HashMap<String, String> = HashMap()
        map.put("userID",""+userID)
        viewModel.getServiceRequestList(map)

        viewModel.serviceRequestResult.observe(viewLifecycleOwner, Observer {
            if (!it.error) {
                initScheduleMeetingRV(it.data)
            }
        })

    }

    private fun initScheduleMeetingRV(arrayList: ArrayList<ServiceRequestListModel>) {

        val scheduleAdapter = ScheduledMeetingAdapter().apply {
            addItems(arrayList)
        }
        scheduleMeetingRV.apply {
            adapter = scheduleAdapter
        }

        scheduleAdapter.listener = { view, item, position ->
            val intent = Intent(context, ViewAnswerActivity::class.java)
            intent.putExtra("serviceRequestID", item.id)
            startActivity(intent)
        }
    }

}