package com.siguiente.fasal.help.fragment

import android.content.Intent
import android.os.Bundle
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import androidx.databinding.DataBindingUtil
import androidx.databinding.Observable
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.FragmentServiceBinding
import com.siguiente.fasal.help.QuestionActivity
import com.siguiente.fasal.help.ServiceViewModel
import com.siguiente.fasal.help.ServiceViewModelFactory
import com.siguiente.fasal.help.adapter.ServiceAdapter
import com.siguiente.fasal.help.model.ServiceModel
import com.siguiente.fasal.home.SubCategoryListActivity
import com.siguiente.fasal.home.adapter.FarmerItemAdapter
import com.siguiente.fasal.home.model.CategoryModel
import com.siguiente.fasal.utils.PreferenceProvider
import com.siguiente.fasal.videos.VideoChatViewActivity
import kotlinx.android.synthetic.main.fragment_home.*
import kotlinx.android.synthetic.main.fragment_service.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance

class ServiceFragment : Fragment(), KodeinAware {
    override val kodein by kodein()
    lateinit var binding: FragmentServiceBinding
    lateinit var viewModel: ServiceViewModel
    val factory: ServiceViewModelFactory by instance()
    val provider: PreferenceProvider by instance()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        binding = DataBindingUtil.inflate(inflater, R.layout.fragment_service, container, false)

        return binding.root
    }


    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProvider(this, factory).get(ServiceViewModel::class.java)
        viewModel.getServices()

        viewModel.serviceResult.observe(viewLifecycleOwner, Observer {
            if (!it.error) {
                initServiceRecyclerView(it.data)
            }
        })

        viewModel.result.observe(viewLifecycleOwner, Observer {
            Toast.makeText(requireContext(), "" + it.message, Toast.LENGTH_SHORT).show()
        })
    }

    private fun initServiceRecyclerView(productsItem: ArrayList<ServiceModel>) {

        val mAdapter = ServiceAdapter().apply {
            addItems(productsItem)
        }

        serviceRecyclerView.apply {
            layoutManager = LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false)
            setHasFixedSize(true)
            adapter = mAdapter
        }

        mAdapter.listener = { view, item, position ->
            if (item.serviceType == "Query") {
                val intent = Intent(context, QuestionActivity::class.java)
                intent.putExtra("serviceID", item.id)
                intent.putExtra("serviceType", item.serviceType)
                startActivity(intent)
            } else {
                serviceRequest(item.id,item.serviceType)
            }

        }

    }

    private fun serviceRequest(serviceID: String, serviceType: String) {
        val map: java.util.HashMap<String, String> = java.util.HashMap()
        val userID = provider.getValueByKey("userID")
        map["userID"] = userID!!
        map["serviceID"] = serviceID
        map["serviceType"] = serviceType
        viewModel.sendServiceRequest(map)
    }
}