package com.siguiente.fasal.home


import android.content.Intent
import android.os.Bundle
import android.os.Handler
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.FragmentHomeBinding
import com.siguiente.fasal.home.adapter.*
import com.siguiente.fasal.home.model.*
import com.siguiente.fasal.shop.activity.ShopListActivity
import kotlinx.android.synthetic.main.fragment_home.*
import org.kodein.di.KodeinAware
import org.kodein.di.generic.instance
import java.util.*
import org.kodein.di.android.x.kodein
import kotlin.collections.ArrayList


class HomeFragment : Fragment(), KodeinAware {
    private lateinit var homeViewModel: HomeViewModel

    private var currentPage = 0
    private var numPages = 0
    lateinit var binding: FragmentHomeBinding
    override val kodein by kodein()
    private val factory: HomeViewModelFactory by instance()


    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        binding = DataBindingUtil.inflate(inflater, R.layout.fragment_home, container, false)

        return binding.root
    }


    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        homeViewModel = ViewModelProvider(this, factory).get(HomeViewModel::class.java)
        homeProgressBar.visibility = View.VISIBLE
        homeViewModel.getCategories()
        homeViewModel.getBanner()
        homeViewModel.getSeedLists()
        val map: HashMap<String, String> = HashMap()
        homeViewModel.getShopLists(map)


        homeViewModel.result.observe(viewLifecycleOwner, androidx.lifecycle.Observer {
            initRecyclerView(it.data)
        })

        homeViewModel.seedResult.observe(viewLifecycleOwner, androidx.lifecycle.Observer {
            homeProgressBar.visibility = View.GONE
            if (!it.error)
                initSeedsRecyclerView(it.data)
        })

        homeViewModel.shopResponse.observe(viewLifecycleOwner, androidx.lifecycle.Observer {
            if (!it.error)
                initShopRecyclerView(it.data)
        })

        homeViewModel.bannerResult.observe(viewLifecycleOwner, androidx.lifecycle.Observer {
            if (!it.error!!)
                homeSliderImplementation(it.data)
        })

        seeMoreDistributorTV.setOnClickListener {
            val intent = Intent(context, ShopListActivity::class.java)
            startActivity(intent)
        }

        seeMoreSeedTV.setOnClickListener {
            val intent = Intent(context, ProductsListActivity::class.java)
            intent.putExtra("Title", "Seed/Grain List")
            startActivity(intent)
        }

    }

    private fun initRecyclerView(productsItem: ArrayList<CategoryModel>) {

        val mAdapter = FarmerItemAdapter().apply {
            addItems(productsItem)
        }

        farmerItemRV.apply {
            layoutManager = LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false)
            setHasFixedSize(true)
            adapter = mAdapter
        }

         mAdapter.listener = { _, _, position ->
            val intent = Intent(context, SubCategoryListActivity::class.java)
            intent.putExtra("categoryID", productsItem[position].categoryID)
            startActivity(intent)
        }

    }
    private fun initSeedsRecyclerView(productsItem: ArrayList<SeedsModel>) {

        val mAdapter = SeedAdapter().apply {
            addItems(productsItem)
        }

        offersItemRV.apply {
            setHasFixedSize(true)
            adapter = mAdapter
        }

        mAdapter.listener = { _, _, position ->
            val intent = Intent(context, ProductDescriptionActivity::class.java)
            intent.putExtra("seedID", productsItem[position].seedID)
            intent.putExtra("imageUrl", productsItem[position].subCategoryImage)
            startActivity(intent)
        }
    }

    private fun initShopRecyclerView(productsItem: ArrayList<ShopModel>) {
        val mAdapter = ShopAdapter().apply {
            addItems(productsItem)
        }

        distributorItemRV.apply {
            setHasFixedSize(true)
            adapter = mAdapter
        }
    }
    private fun homeSliderImplementation(bannerArrayList: ArrayList<BannerModel>) {
        val adapter = HomeBannerSliderAdapter(requireContext(), bannerArrayList)
        homeBannerVP.adapter = adapter
        homeTabLayout.setupWithViewPager(homeBannerVP)
        initViewPager(bannerArrayList)
    }

    private fun initViewPager(bannerArrayList: ArrayList<BannerModel>) {
        numPages = bannerArrayList.size
        val handler = Handler()
        val update = Runnable {
            if (currentPage == numPages) {
                currentPage = 0
            }
            homeBannerVP?.setCurrentItem(
                currentPage++,
                true
            )
        }
        val swipeTimer = Timer()
        swipeTimer.schedule(object : TimerTask() {
            override fun run() {
                handler.post(update)
            }
        }, 3000, 3000)
    }
}