package com.siguiente.fasal.home

import com.siguiente.fasal.network.MyApi
import com.siguiente.fasal.network.SafeApiRequest
import com.siguiente.fasal.network.response.BannerResponse
import com.siguiente.fasal.network.response.CategoryResponse
import com.siguiente.fasal.network.response.SeedResponse
import com.siguiente.fasal.network.response.ShopResponse

class HomeRepository(
    private val api: MyApi
) : SafeApiRequest() {

    suspend fun getCategories(): CategoryResponse {
        return apiRequest { api.getCategories() }
    }

    suspend fun getBanner(): BannerResponse {
        return apiRequest { api.getBanner() }
    }

    suspend fun getShopList(field:HashMap<String,String>): ShopResponse {
        return apiRequest { api.getAllShopList(field) }
    }

    suspend fun getAllSeedList(): SeedResponse {
        return apiRequest { api.getAllSeedList() }
    }

    suspend fun getAllSeedListByID(field:HashMap<String,String>): SeedResponse {
        return apiRequest { api.getUserSeedList(field) }
    }


}