package com.siguiente.fasal.home

import android.util.Log
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasal.network.response.BannerResponse
import com.siguiente.fasal.network.response.CategoryResponse
import com.siguiente.fasal.network.response.SeedResponse
import com.siguiente.fasal.network.response.ShopResponse
import com.siguiente.fasal.utils.ApiException
import com.siguiente.fasal.utils.Coroutines
import com.siguiente.fasal.utils.NoInternetException

class HomeViewModel(val repository: HomeRepository) : ViewModel() {

    var result = MutableLiveData<CategoryResponse>()
    var bannerResult = MutableLiveData<BannerResponse>()
    var seedResult = MutableLiveData<SeedResponse>()
    var seedsByUserResult = MutableLiveData<SeedResponse>()
    var shopResponse = MutableLiveData<ShopResponse>()

    //For Getting Category
    fun getCategories(){
        Coroutines.main {
            try {
                val response = repository.getCategories()
                if (response.error != true) {
                    result.value = response
                    Log.e("CategoriesResponse -", "" + response.toString())
                } else {
                    result.value = response
                    Log.e("CategoriesResponse-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    //For Getting Banner
    fun getBanner(){
        Coroutines.main {
            try {
                val response = repository.getBanner()
                if (response.error != true) {
                    bannerResult.value = response
                    Log.e("BannerResponse -", "" + response.toString())
                } else {
                    bannerResult.value = response
                    Log.e("BannerResponse-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    //For Seeds List
    fun getSeedLists(){
        Coroutines.main {
            try {
                val response = repository.getAllSeedList()
                if (!response.error) {
                    seedResult.value = response
                    Log.e("SeedResponse -", "" + response.toString())
                } else {
                    seedResult.value = response
                    Log.e("SeedResponse-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    //For Shop List
    fun getShopLists(field:HashMap<String,String>){
        Coroutines.main {
            try {
                val response = repository.getShopList(field)
                if (!response.error) {
                    shopResponse.value = response
                    Log.e("ShopResponse -", "" + response.toString())
                } else {
                    shopResponse.value = response
                    Log.e("ShopResponse-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    //For Seeds List
    fun getSeedListsByID(field:HashMap<String,String>){
        Coroutines.main {
            try {
                val response = repository.getAllSeedListByID(field)
                if (!response.error) {
                    seedsByUserResult.value = response
                    Log.e("SeedResponse -", "" + response.toString())
                } else {
                    seedsByUserResult.value = response
                    Log.e("SeedResponse-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }
}