package com.siguiente.fasal.home

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.util.Log
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.ViewModelProvider
import com.bumptech.glide.Glide
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivityProductDescriptionBinding
import com.siguiente.fasal.my_store.MyStoreViewModel
import com.siguiente.fasal.my_store.StoreViewModelFactory
import com.siguiente.fasal.utils.PreferenceProvider
import com.siguiente.fasal.utils.toast
import kotlinx.android.synthetic.main.activity_product_description.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance
import java.util.*

class ProductDescriptionActivity : AppCompatActivity(), KodeinAware {

    lateinit var binding: ActivityProductDescriptionBinding
    val provider: PreferenceProvider by instance()
    override val kodein by kodein()
    private lateinit var storeViewModel: MyStoreViewModel
    private val factoryStore: StoreViewModelFactory by instance()
    private var seedID = ""
    private var imageUrl = ""


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_product_description)
        supportActionBar?.hide()
        storeViewModel = ViewModelProvider(this, factoryStore).get(MyStoreViewModel::class.java)

        seedID = intent.extras?.getString("seedID", "").toString()
        imageUrl = intent.extras?.getString("imageUrl", "").toString()
        val map: HashMap<String, String> = HashMap()
        map["seedID"] = seedID
        storeViewModel.viewSeedsAndGrains(map)

        storeViewModel.viewSeedGrainsResult.observe(this, androidx.lifecycle.Observer {
            binding.storeViewModel = it
        })

        val url = resources.getString(R.string.bannerUrl) + "subcategory/" + imageUrl
        Log.e("ImageUrl", "" + url)

        Glide.with(this)
            .load(url)
            .into(descriptionBannerVP)

        pDescriptionBackIV.setOnClickListener {
            onBackPressed()
        }

        requestForBuyButton.setOnClickListener {
            val userType = provider.getValueByKey("userType")!!
            if (userType == "3") {
                val requestBottomSheet = RequestFragment()
                val bundle = Bundle()
                bundle.putString("seedID", seedID)
                requestBottomSheet.arguments = bundle
                requestBottomSheet.show(supportFragmentManager, "Request Fragment")
            } else {
                toast("You are not eligible for Request")
            }


        }
    }

}