package com.siguiente.fasal.home

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.Menu
import android.view.View
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivityProductsListBinding
import com.siguiente.fasal.home.adapter.ProductsListAdapter
import com.siguiente.fasal.home.model.SeedsModel
import kotlinx.android.synthetic.main.activity_products_list.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance
import java.util.ArrayList

class ProductsListActivity : AppCompatActivity(), KodeinAware {

    override val kodein by kodein()
    private lateinit var homeViewModel: HomeViewModel
    private val factory: HomeViewModelFactory by instance()
    private lateinit var titleString: String
    private lateinit var binding: ActivityProductsListBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_products_list)
        supportActionBar?.hide()
        productListProgressBar.visibility = View.VISIBLE
        titleString = intent.extras?.getString("Title").toString()
        homeViewModel = ViewModelProvider(this, factory).get(HomeViewModel::class.java)
        homeViewModel.getSeedLists()
        productListTitleTV.text = titleString

        homeViewModel.seedResult.observe(this, androidx.lifecycle.Observer {
            initSeedsRecyclerView(it.data)
        })

        productListBackIV.setOnClickListener {
            onBackPressed()
        }

    }

    private fun initSeedsRecyclerView(productsItem: ArrayList<SeedsModel>) {
        productListProgressBar.visibility = View.GONE
        val mAdapter = ProductsListAdapter("Product").apply {
            addItems(productsItem)
        }

        productsListRV.apply {
            setHasFixedSize(true)
            adapter = mAdapter
        }
    }


    override fun onCreateOptionsMenu(menu: Menu?): Boolean {
        menuInflater.inflate(R.menu.search, menu)
        return true
    }
}