package com.siguiente.fasal.home

import androidx.lifecycle.ViewModelProvider
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.RequestFragmentBinding
import com.siguiente.fasal.dialog.MessageDialog
import com.siguiente.fasal.utils.PreferenceProvider
import kotlinx.android.synthetic.main.request_fragment.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance

class RequestFragment : BottomSheetDialogFragment(), KodeinAware {

    lateinit var binding: RequestFragmentBinding
    override val kodein by kodein()
    val provider: PreferenceProvider by instance()
    val factory: RequestViewModelFactory by instance()
    private var seedID = ""

    companion object {
        fun newInstance() = RequestFragment()
    }

    private lateinit var viewModel: RequestViewModel

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = DataBindingUtil.inflate(inflater, R.layout.request_fragment, container, false)

        return binding.root
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProvider(this, factory).get(RequestViewModel::class.java)
        seedID = requireArguments().getString("seedID", "")
        viewModel.requestResponse.observe(viewLifecycleOwner, Observer {
            val msgDialog = MessageDialog(it.message.toString())
            msgDialog.show(childFragmentManager, "MessageDialog")
            dismiss()
        })

        requestSampleCloseIV.setOnClickListener {
            dismiss()
        }


        submitRequestButton.setOnClickListener {
            if (!requestQuantityET.text.isNullOrEmpty()) {
                requestSample()
            } else {
                requestQuantityET.error = "Enter quantity"
            }


        }
    }

    private fun requestSample() {
        val userID = provider.getValueByKey("userID")!!
        val map: HashMap<String, String> = HashMap()
        map["userID"] = userID
        map["seedID"] = seedID
        map["quantity"] = requestQuantityET.text.toString()
        map["description"] = requestDescriptionET.text.toString()
        viewModel.requestSample(map)

    }

}