package com.siguiente.fasal.home

import android.util.Log
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasal.network.response.CommonResponse
import com.siguiente.fasal.network.response.RequestSampleResponse
import com.siguiente.fasal.utils.ApiException
import com.siguiente.fasal.utils.Coroutines
import com.siguiente.fasal.utils.NoInternetException

class RequestViewModel(
    val repository: RequestRepository
) : ViewModel() {
    var requestResponse = MutableLiveData<CommonResponse>()
    var requestSampleListResponse = MutableLiveData<RequestSampleResponse>()

    fun requestSample(field:HashMap<String,String>) {
        Coroutines.main {
            try {
                val response = repository.requestSample(field)
                if (response.error != true) {
                    requestResponse.value = response
                    Log.e("RequestSample -", "" + response.toString())
                } else {
                    requestResponse.value = response
                    Log.e("RequestSample-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun requestSampleList(field:HashMap<String,String>) {
        Coroutines.main {
            try {
                val response = repository.requestSampleHistory(field)
                Log.e("RequestSampleL -", "" + response.toString())
                if (response.error != true) {
                    requestSampleListResponse.value = response
                    Log.e("RequestSampleL -", "" + response.toString())
                } else {
                    requestSampleListResponse.value = response
                    Log.e("RequestSampleL-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }
}