package com.siguiente.fasal.home

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.View
import androidx.core.view.isVisible
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivitySubCategoryListBinding
import com.siguiente.fasal.home.adapter.SubCategoryListAdapter
import com.siguiente.fasal.home.model.SeedsModel
import com.siguiente.fasal.my_store.MyStoreViewModel
import com.siguiente.fasal.my_store.StoreViewModelFactory
import kotlinx.android.synthetic.main.activity_add_product.*
import kotlinx.android.synthetic.main.activity_products_list.*
import kotlinx.android.synthetic.main.activity_sub_category_list.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance
import java.util.ArrayList

class SubCategoryListActivity : AppCompatActivity(), KodeinAware {

    lateinit var binding: ActivitySubCategoryListBinding
    override val kodein by kodein()
    private lateinit var storeViewModel: MyStoreViewModel
    private val factoryStore: StoreViewModelFactory by instance()
    private var categoryID = ""


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_sub_category_list)
        supportActionBar?.hide()
        subCategoryListProgressBar.isVisible = true
        storeViewModel = ViewModelProvider(this, factoryStore).get(MyStoreViewModel::class.java)
        categoryID = intent.extras!!.getString("categoryID", "")
        val map: java.util.HashMap<String, String> = java.util.HashMap()
        map["categoryID"] = categoryID
        storeViewModel.getSeedListByCategory(map)


        storeViewModel.seedByCategoryResult.observe(this, Observer {
            if (!it.error) {
                subCategoryListProgressBar.isVisible = false
                initSubCategoryRecyclerView(it.data)
                noDataFoundSTV.visibility = View.GONE
            } else {
                subCategoryListProgressBar.isVisible = false
                noDataFoundSTV.visibility = View.VISIBLE
            }
        })


        subCategoryBackIV.setOnClickListener {
            onBackPressed()
        }

    }


    private fun initSubCategoryRecyclerView(productsItem: ArrayList<SeedsModel>) {
        val mAdapter = SubCategoryListAdapter().apply {
            addItems(productsItem)
        }

        seedsByCategoryRV.apply {
            setHasFixedSize(true)
            adapter = mAdapter
        }

        mAdapter.listener = { _, _, position ->

            val intent =
                Intent(this@SubCategoryListActivity, ProductDescriptionActivity::class.java)
            intent.putExtra("seedID", productsItem[position].seedID)
            intent.putExtra("imageUrl", productsItem[position].subCategoryImage)
            startActivity(intent)
        }

    }
}