package com.siguiente.fasal.home.adapter


import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.FarmerItemDesignBinding
import com.siguiente.fasal.home.model.CategoryModel
import com.siguiente.fasal.utils.BaseRecyclerViewAdapter


class FarmerItemAdapter: BaseRecyclerViewAdapter<CategoryModel, FarmerItemDesignBinding>() {
    override fun getLayout() = R.layout.farmer_item_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<FarmerItemDesignBinding>,
        position: Int
    ) {
        holder.binding.categoryModel = items[position]
        holder.binding.root.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

    }

}