package com.siguiente.fasal.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.viewpager.widget.PagerAdapter
import androidx.viewpager.widget.ViewPager
import com.bumptech.glide.Glide
import com.siguiente.fasal.R
import com.siguiente.fasal.home.model.BannerModel
import kotlinx.android.synthetic.main.home_banner_slider_design.view.*


class HomeBannerSliderAdapter(
    private val context: Context,
    private val images: ArrayList<BannerModel>
) : PagerAdapter() {


    private var inflater: LayoutInflater? = null

    override fun isViewFromObject(view: View, `object`: Any): Boolean {

        return view === `object`
    }

    override fun getCount(): Int {
        return images.size
    }

    override fun instantiateItem(container: ViewGroup, position: Int): Any {

        inflater = context.getSystemService(Context.LAYOUT_INFLATER_SERVICE) as LayoutInflater
        val view = inflater!!.inflate(R.layout.home_banner_slider_design, null)
        val url =
            context.resources.getString(R.string.bannerUrl) + "banner/" + images[position].bannerImage
        Glide.with(context).load(url).optionalCenterCrop().into(view.homeBannerIV)

        val vp = container as ViewPager
        vp.addView(view, 0)
        return view
    }

    override fun destroyItem(container: ViewGroup, position: Int, `object`: Any) {
        val vp = container as ViewPager
        val view = `object` as View
        vp.removeView(view)
    }

}