package com.siguiente.fasal.home.adapter

import android.view.View
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ProductsItemDesignBinding
import com.siguiente.fasal.home.model.SeedsModel
import com.siguiente.fasal.utils.BaseRecyclerViewAdapter
import com.siguiente.fasal.utils.PreferenceProvider


class ProductsListAdapter(val type:String): BaseRecyclerViewAdapter<SeedsModel, ProductsItemDesignBinding>() {
    override fun getLayout() = R.layout.products_item_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<ProductsItemDesignBinding>,
        position: Int
    ) {
        holder.binding.seedModel = items[position]
        holder.binding.productCardView.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

        holder.binding.deleteSeedImageView.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

        if (type == "Store"){
            holder.binding.deleteSeedImageView.visibility = View.VISIBLE
        }else{
            holder.binding.deleteSeedImageView.visibility = View.GONE
        }


    }

}