package com.siguiente.fasal.home.adapter

import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.SeedDesignBinding
import com.siguiente.fasal.home.model.SeedsModel
import com.siguiente.fasal.utils.BaseRecyclerViewAdapter

class SeedAdapter : BaseRecyclerViewAdapter<SeedsModel, SeedDesignBinding>() {
    override fun getLayout() = R.layout.seed_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<SeedDesignBinding>,
        position: Int
    ) {
        holder.binding.seedModel = items[position]
        holder.binding.root.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

    }

}