package com.siguiente.fasal.home.adapter

import android.view.View
import com.bumptech.glide.Glide
import com.bumptech.glide.load.engine.DiskCacheStrategy
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ShopDesignBinding
import com.siguiente.fasal.home.model.ShopModel
import com.siguiente.fasal.utils.BaseRecyclerViewAdapter

class ShopAdapter: BaseRecyclerViewAdapter<ShopModel, ShopDesignBinding>() {
    override fun getLayout() = R.layout.shop_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<ShopDesignBinding>,
        position: Int
    ) {
        holder.binding.shopModel = items[position]
        holder.binding.root.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }
        val photo = items[position].photo
        if (photo != null) {
            holder.binding.shopItemTV.visibility = View.GONE
            holder.binding.shopImageIV.visibility = View.VISIBLE
        }else{
            holder.binding.shopItemTV.visibility = View.VISIBLE
            holder.binding.shopItemTV.text = ""+items[position].shopName.substring(0,1).toUpperCase()
            holder.binding.shopImageIV.visibility = View.GONE
        }

    }

}