package com.siguiente.fasal.home.adapter

import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.SubCategoryListItemBinding
import com.siguiente.fasal.home.model.SeedsModel
import com.siguiente.fasal.my_store.model.SubCategoryModel
import com.siguiente.fasal.utils.BaseRecyclerViewAdapter

class SubCategoryListAdapter: BaseRecyclerViewAdapter<SeedsModel, SubCategoryListItemBinding>() {
    override fun getLayout() = R.layout.sub_category_list_item

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<SubCategoryListItemBinding>,
        position: Int
    ) {
        holder.binding.subCategoryModel = items[position]
        holder.binding.root.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

    }

}