package com.siguiente.fasal.imageCrop

import android.animation.ValueAnimator
import android.animation.ValueAnimator.AnimatorUpdateListener
import android.graphics.*
import android.graphics.drawable.Drawable
import android.os.Handler
import android.view.animation.LinearInterpolator
import kotlin.math.roundToInt


/**
 * Created by Yashar on 3/8/2017.
 */
open class GridDrawable() : Drawable() {
    private val mHandler: Handler = Handler()
    private val mPreviousBounds = Rect()
    private val mLinePaint: Paint = Paint()
    private val mLineBorderPaint: Paint
    private val mAnimator = ValueAnimator()
    private var mAlpha = 1f
    override fun setBounds(left: Int, top: Int, right: Int, bottom: Int) {
        super.setBounds(left, top, right, bottom)
        mAlpha = 1f
        invalidateSelf()
        mAnimator.cancel()
        mAnimator.start()
    }

    override fun draw(canvas: Canvas) {
        mLinePaint.alpha = (mAlpha * 255).roundToInt()
        mLineBorderPaint.alpha = (mAlpha * 0x44).roundToInt()
        val bounds = bounds
        val width = bounds.width()
        val height = bounds.height()
        val left = bounds.left + width / 3
        val right = left + width / 3
        val top = bounds.top + height / 3
        val bottom = top + height / 3
        canvas.drawLine(
            (left - 1).toFloat(),
            bounds.top.toFloat(),
            (left - 1).toFloat(),
            bounds.bottom.toFloat(),
            mLineBorderPaint
        )
        canvas.drawLine(
            (left + 1).toFloat(),
            bounds.top.toFloat(),
            (left + 1).toFloat(),
            bounds.bottom.toFloat(),
            mLineBorderPaint
        )
        canvas.drawLine(
            (right - 1).toFloat(),
            bounds.top.toFloat(),
            (right - 1).toFloat(),
            bounds.bottom.toFloat(),
            mLineBorderPaint
        )
        canvas.drawLine(
            (right + 1).toFloat(),
            bounds.top.toFloat(),
            (right + 1).toFloat(),
            bounds.bottom.toFloat(),
            mLineBorderPaint
        )
        canvas.drawLine(
            bounds.left.toFloat(),
            (top - 1).toFloat(),
            bounds.right.toFloat(),
            (top - 1).toFloat(),
            mLineBorderPaint
        )
        canvas.drawLine(
            bounds.left.toFloat(),
            (top + 1).toFloat(),
            bounds.right.toFloat(),
            (top + 1).toFloat(),
            mLineBorderPaint
        )
        canvas.drawLine(
            bounds.left.toFloat(),
            (bottom - 1).toFloat(),
            bounds.right.toFloat(),
            (bottom - 1).toFloat(),
            mLineBorderPaint
        )
        canvas.drawLine(
            bounds.left.toFloat(),
            (bottom + 1).toFloat(),
            bounds.right.toFloat(),
            (bottom + 1).toFloat(),
            mLineBorderPaint
        )
        canvas.drawLine(
            left.toFloat(),
            bounds.top.toFloat(),
            left.toFloat(),
            bounds.bottom.toFloat(),
            mLinePaint
        )
        canvas.drawLine(
            right.toFloat(),
            bounds.top.toFloat(),
            right.toFloat(),
            bounds.bottom.toFloat(),
            mLinePaint
        )
        canvas.drawLine(
            bounds.left.toFloat(),
            top.toFloat(),
            bounds.right.toFloat(),
            top.toFloat(),
            mLinePaint
        )
        canvas.drawLine(
            bounds.left.toFloat(),
            bottom.toFloat(),
            bounds.right.toFloat(),
            bottom.toFloat(),
            mLinePaint
        )
    }

    override fun setAlpha(alpha: Int) {}
    override fun setColorFilter(colorFilter: ColorFilter?) {}
    override fun getOpacity(): Int {
        return PixelFormat.OPAQUE
    }

    private val mAnimatorUpdateListener =
        AnimatorUpdateListener { animation ->
            mAlpha = animation.animatedValue as Float
            invalidateSelf()
        }

    companion object {
        private const val LINE_COLOR = Color.WHITE
        private const val LINE_BORDER_COLOR = 0x44888888
        private const val LINE_STROKE_WIDTH = 1f
        private const val TIME_BEFORE_FADE: Long = 300
        private const val TIME_TO_FADE: Long = 300
    }

    init {
        mLinePaint.style = Paint.Style.STROKE
        mLinePaint.color = LINE_COLOR
        mLinePaint.strokeWidth = LINE_STROKE_WIDTH
        mLineBorderPaint = Paint()
        mLineBorderPaint.style = Paint.Style.STROKE
        mLineBorderPaint.color = LINE_BORDER_COLOR
        mLineBorderPaint.strokeWidth = LINE_STROKE_WIDTH
        mAnimator.duration = TIME_TO_FADE
        mAnimator.startDelay = TIME_BEFORE_FADE
        mAnimator.setFloatValues(1f, 0f)
        mAnimator.addUpdateListener(mAnimatorUpdateListener)
        mAnimator.interpolator = LinearInterpolator()
        mAnimator.start()
    }
}