package com.siguiente.fasal.imageCrop

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Context
import android.content.Intent
import android.graphics.Bitmap
import android.net.Uri
import android.os.AsyncTask
import android.os.Bundle
import android.provider.MediaStore
import android.view.View
import android.widget.ImageView
import com.siguiente.fasal.R
import java.io.IOException



class ImageCropperActivity : Activity() {
    private var mInstaCropper: InstaCropperView? = null
    private var mWidthSpec = 0
    private var mHeightSpec = 0
    private var mOutputQuality = 0
    private var mOutputUri: Uri? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_image_cropper)
        mInstaCropper = findViewById<View>(R.id.instacropper) as InstaCropperView

        val intent = intent
        val uri = intent.data
        val defaultRatio =
            intent.getFloatExtra(EXTRA_PREFERRED_RATIO, InstaCropperView.DEFAULT_RATIO)
        val minimumRatio =
            intent.getFloatExtra(EXTRA_MINIMUM_RATIO, InstaCropperView.DEFAULT_MINIMUM_RATIO)
        val maximumRatio =
            intent.getFloatExtra(EXTRA_MAXIMUM_RATIO, InstaCropperView.DEFAULT_MAXIMUM_RATIO)
        mInstaCropper!!.setRatios(defaultRatio, minimumRatio, maximumRatio)
        mInstaCropper!!.setImageUri(uri)
        mWidthSpec = intent.getIntExtra(
            EXTRA_WIDTH_SPEC,
            View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED)
        )
        mHeightSpec = intent.getIntExtra(
            EXTRA_HEIGHT_SPEC,
            View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED)
        )
        mOutputQuality = intent.getIntExtra(EXTRA_OUTPUT_QUALITY, DEFAULT_OUTPUT_QUALITY)
        mOutputUri = intent.getParcelableExtra(EXTRA_OUTPUT)

        val doneAction: ImageView = findViewById(R.id.imageCropperDoneButton)
        doneAction.setOnClickListener {
            mInstaCropper!!.crop(mWidthSpec, mHeightSpec, mBitmapCallback)
        }
    }


    @SuppressLint("StaticFieldLeak")
    private val mBitmapCallback: InstaCropperView.BitmapCallback =
        object : InstaCropperView.BitmapCallback {
            override fun onBitmapReady(bitmap: Bitmap?) {
                if (bitmap == null) {
                    setResult(RESULT_CANCELED)
                    finish()
                    return
                }
                object : AsyncTask<Void?, Void?, Boolean>() {
                    protected override fun doInBackground(vararg params: Void?): Boolean {
                        try {
                            val os = contentResolver.openOutputStream(mOutputUri!!)
                            bitmap.compress(Bitmap.CompressFormat.JPEG, mOutputQuality, os)
                            os!!.flush()
                            os.close()
                            return true
                        } catch (e: IOException) {
                        }
                        return false
                    }

                    override fun onPostExecute(success: Boolean) {
                        if (success) {
                            val data = Intent()
                            data.data = mOutputUri
                            setResult(RESULT_OK, data)
                        } else {
                            setResult(RESULT_CANCELED)
                        }
                        finish()
                    }
                }.execute()
            }
        }

    companion object {
        const val DEFAULT_OUTPUT_QUALITY = 80
        const val EXTRA_OUTPUT = MediaStore.EXTRA_OUTPUT
        const val EXTRA_PREFERRED_RATIO = "preferred_ratio"
        const val EXTRA_MINIMUM_RATIO = "minimum_ratio"
        const val EXTRA_MAXIMUM_RATIO = "maximum_ratio"
        const val EXTRA_WIDTH_SPEC = "width_spec"
        const val EXTRA_HEIGHT_SPEC = "height_spec"
        const val EXTRA_OUTPUT_QUALITY = "output_quality"
        fun getIntent(
            context: Context?,
            src: Uri?,
            dst: Uri?,
            maxWidth: Int,
            outputQuality: Int
        ): Intent {
            return getIntent(
                context,
                src,
                dst,
                View.MeasureSpec.makeMeasureSpec(maxWidth, View.MeasureSpec.AT_MOST),
                View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED),
                outputQuality
            )
        }

        private fun getIntent(
            context: Context?,
            src: Uri?,
            dst: Uri?,
            widthSpec: Int,
            heightSpec: Int,
            outputQuality: Int
        ): Intent {
            return getIntent(
                context,
                src,
                dst,
                InstaCropperView.DEFAULT_RATIO,
                InstaCropperView.DEFAULT_MINIMUM_RATIO,
                InstaCropperView.DEFAULT_MAXIMUM_RATIO,
                widthSpec,
                heightSpec,
                outputQuality
            )
        }

        private fun getIntent(
            context: Context?, src: Uri?, dst: Uri?,
            preferredRatio: Float, minimumRatio: Float, maximumRatio: Float,
            widthSpec: Int, heightSpec: Int, outputQuality: Int
        ): Intent {
            val intent = Intent(context, ImageCropperActivity::class.java)
            intent.data = src
            intent.putExtra(EXTRA_OUTPUT, dst)
            intent.putExtra(EXTRA_PREFERRED_RATIO, preferredRatio)
            intent.putExtra(EXTRA_MINIMUM_RATIO, minimumRatio)
            intent.putExtra(EXTRA_MAXIMUM_RATIO, maximumRatio)
            intent.putExtra(EXTRA_WIDTH_SPEC, widthSpec)
            intent.putExtra(EXTRA_HEIGHT_SPEC, heightSpec)
            intent.putExtra(EXTRA_OUTPUT_QUALITY, outputQuality)
            return intent
        }
    }
}