package com.siguiente.fasal.imageCrop

import android.content.Intent
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.net.Uri
import android.os.Bundle
import android.os.Environment
import android.provider.MediaStore
import android.util.Base64
import android.util.Log
import android.view.View
import android.widget.ImageView
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasal.R
import com.siguiente.fasal.account.TransactionHisViewModel
import com.siguiente.fasal.profile.ProfileViewModel
import com.siguiente.fasal.profile.ProfileViewModelFactory
import com.siguiente.fasal.utils.PreferenceProvider
import com.siguiente.fasal.utils.toast
import kotlinx.android.synthetic.main.document_fragment.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance
import java.io.ByteArrayOutputStream
import java.io.File
import java.io.FileInputStream
import java.io.IOException


class ImageSelectorActivity : AppCompatActivity(), KodeinAware {
    private val TAG = "ImageSelectorActivity"
    private var mInstaCropper: InstaCropperView? = null
    var base64Image = ""
    override val kodein by kodein()
    private lateinit var viewModel: ProfileViewModel
    private lateinit var viewModelTrans: TransactionHisViewModel
    val factory: ProfileViewModelFactory by instance()
    val provider: PreferenceProvider by instance()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_image_selector)
        mInstaCropper = findViewById(R.id.instacropper)
        viewModel = ViewModelProvider(this, factory).get(ProfileViewModel::class.java)


        viewModel.uploadPhotoResult.observe(this, Observer {
            if (!it.error!!) {
                toast(it.message.toString())
                this.finish()
            }
        })

    }

    fun pickPhoto(v: View?) {
        val intent = Intent(Intent.ACTION_PICK)
        intent.data = MediaStore.Images.Media.EXTERNAL_CONTENT_URI
        startActivityForResult(intent, 1)

    }

    fun uploadPhoto(view: View?) {
        if (base64Image.isNotEmpty()) {
            val userID = provider.getValueByKey("userID")!!
            val map: HashMap<String, String> = HashMap()
            map["userID"] = userID
            map["photo"] = base64Image
            viewModel.uploadPhoto(map)
        }
    }

    private fun toBase64(bm: Bitmap): String? {
        val baos = ByteArrayOutputStream()
        bm.compress(Bitmap.CompressFormat.PNG, 100, baos) //bm is the bitmap object
        val b: ByteArray = baos.toByteArray()
        return Base64.encodeToString(b, Base64.NO_WRAP)
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        when (requestCode) {
            1 -> {
                if (resultCode == RESULT_OK) {
                    val intent: Intent = ImageCropperActivity.getIntent(
                        this, data!!.data, Uri.fromFile(
                            File(
                                externalCacheDir, "test.jpg"
                            )
                        ), 720, 50
                    )
                    startActivityForResult(intent, 2)
                }
                return
            }
            2 -> {
                if (resultCode == RESULT_OK) {
                    mInstaCropper!!.setImageUri(data!!.data)
                    val imageUri: Uri? = data.data
                    var bitmap: Bitmap? = null
                    try {
                        bitmap =
                            MediaStore.Images.Media.getBitmap(contentResolver, imageUri)
                    } catch (e: IOException) {
                        e.printStackTrace()
                    }
                    base64Image = toBase64(bitmap!!)!!
                    Log.e("base64Image-", "" + base64Image)
                }
                return
            }
        }
    }


}