package com.siguiente.fasal.imageCrop

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.view.View


class MultipleCropActivity : Activity() {
    private var mSources: MultipleUris? = null
    private var mDestinations: MultipleUris? = null
    private var mIndex = 0
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        val intent = intent
        val srcUri = intent.data
        val dstUri = intent.getParcelableExtra<Uri>(EXTRA_OUTPUT)
        require(!(srcUri == null || dstUri == null)) { "Source or destination is not provided." }
        mSources = MultipleUris(srcUri)
        mDestinations = MultipleUris(dstUri)
        require(mSources!!.size() == mDestinations!!.size()) { "Source and destination URIs must have the same length." }
        if (savedInstanceState == null) {
            mIndex = 0
            goNext()
        } else {
            mIndex = savedInstanceState.getInt(KEY_INDEX)
        }
    }

    private fun goNext() {
        if (mIndex == mSources!!.size()) {
            val output = Intent()
            output.data = mDestinations!!.toUri()
            output.putExtra(EXTRA_COUNT, mIndex)
            setResult(RESULT_OK, output)
            finish()
            return
        }
        val source = mSources!!.uris[mIndex]
        val destination = mDestinations!!.uris[mIndex]
        val intent = Intent(intent)
        intent.setClass(this, ImageCropperActivity::class.java)
        intent.data = source
        intent.putExtra(EXTRA_OUTPUT, destination)
        startActivityForResult(intent, 0)
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent) {
        if (resultCode == RESULT_CANCELED) {
            val output = Intent()
            output.data = mDestinations!!.toUri()
            output.putExtra(EXTRA_COUNT, mIndex)
            setResult(RESULT_CANCELED, output)
            finish()
            return
        }
        mIndex++
        goNext()
    }

    override fun onSaveInstanceState(outState: Bundle) {
        super.onSaveInstanceState(outState)
        outState.putInt(KEY_INDEX, mIndex)
    }

    companion object {
        const val EXTRA_OUTPUT: String = ImageCropperActivity.EXTRA_OUTPUT
        const val EXTRA_COUNT = "count"
        private const val EXTRA_PREFERRED_RATIO: String = ImageCropperActivity.EXTRA_PREFERRED_RATIO
        private const val EXTRA_MINIMUM_RATIO: String = ImageCropperActivity.EXTRA_MINIMUM_RATIO
        private const val EXTRA_MAXIMUM_RATIO: String = ImageCropperActivity.EXTRA_MAXIMUM_RATIO
        private const val EXTRA_WIDTH_SPEC: String = ImageCropperActivity.EXTRA_WIDTH_SPEC
        private const val EXTRA_HEIGHT_SPEC: String = ImageCropperActivity.EXTRA_HEIGHT_SPEC
        private const val EXTRA_OUTPUT_QUALITY: String = ImageCropperActivity.EXTRA_OUTPUT_QUALITY
        private const val KEY_INDEX = "index"
        fun getIntent(
            context: Context?, src: MultipleUris, dst: MultipleUris,
            maxWidth: Int, outputQuality: Int
        ): Intent {
            val intent = Intent(context, MultipleCropActivity::class.java)
            intent.data = src.toUri()
            intent.putExtra(EXTRA_OUTPUT, dst.toUri())
            intent.putExtra(EXTRA_PREFERRED_RATIO, InstaCropperView.DEFAULT_RATIO)
            intent.putExtra(EXTRA_MINIMUM_RATIO, InstaCropperView.DEFAULT_MINIMUM_RATIO)
            intent.putExtra(EXTRA_MAXIMUM_RATIO, InstaCropperView.DEFAULT_MAXIMUM_RATIO)
            intent.putExtra(
                EXTRA_WIDTH_SPEC,
                View.MeasureSpec.makeMeasureSpec(maxWidth, View.MeasureSpec.AT_MOST)
            )
            intent.putExtra(
                EXTRA_HEIGHT_SPEC,
                View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED)
            )
            intent.putExtra(EXTRA_OUTPUT_QUALITY, outputQuality)
            return intent
        }

        fun getIntent(
            context: Context?, src: MultipleUris, dst: MultipleUris,
            maxWidth: Int, maxHeight: Int, aspectRatio: Float
        ): Intent {
            val intent = Intent(context, MultipleCropActivity::class.java)
            intent.data = src.toUri()
            intent.putExtra(EXTRA_OUTPUT, dst.toUri())
            intent.putExtra(EXTRA_PREFERRED_RATIO, aspectRatio)
            intent.putExtra(EXTRA_MINIMUM_RATIO, aspectRatio)
            intent.putExtra(EXTRA_MAXIMUM_RATIO, aspectRatio)
            intent.putExtra(
                EXTRA_WIDTH_SPEC,
                View.MeasureSpec.makeMeasureSpec(maxWidth, View.MeasureSpec.AT_MOST)
            )
            intent.putExtra(
                EXTRA_HEIGHT_SPEC,
                View.MeasureSpec.makeMeasureSpec(maxHeight, View.MeasureSpec.AT_MOST)
            )
            intent.putExtra(EXTRA_OUTPUT_QUALITY, ImageCropperActivity.DEFAULT_OUTPUT_QUALITY)
            return intent
        }
    }
}