package com.siguiente.fasal.imageCrop

import android.net.Uri
import java.util.*


class MultipleUris {
    private var mUris: MutableList<Uri>

    constructor(vararg uris: Uri?) {
        mUris = ArrayList(uris.size)
      /*  Collections.addAll(mUris, *uris)
        mUris.addAll(uris)*/
    }

    constructor(uris: List<Uri>?) {
        mUris = ArrayList(uris)
    }

    constructor(uri: Uri) {
        mUris = ArrayList(5)
        for (name in uri.queryParameterNames) {
            mUris.add(Uri.parse(uri.getQueryParameter(name)))
        }
    }

    constructor() {
        mUris = ArrayList(5)
    }

    fun add(uri: Uri): MultipleUris {
        mUris.add(uri)
        return this
    }

    fun remove(uri: Uri?): MultipleUris {
        mUris.remove(uri)
        return this
    }

    val uris: List<Uri>
        get() = mUris

    fun size(): Int {
        return mUris.size
    }

    fun toUri(): Uri {
        val sb = StringBuilder()
        sb.append(FAKE).append("://").append(FAKE).append("/?")
        for (i in mUris.indices) {
            if (i > 0) {
                sb.append("&")
            }
            sb.append(i).append("=").append(mUris[i])
        }
        return Uri.parse(sb.toString())
    }

    companion object {
        private const val FAKE = "_MultipleUris"
    }
}