package com.siguiente.fasal.information


import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivityInformationBinding
import kotlinx.android.synthetic.main.activity_information.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance

class InformationActivity : AppCompatActivity(), KodeinAware {
    override val kodein by kodein()
    lateinit var binding: ActivityInformationBinding
    lateinit var viewModel: InformationViewModel
    val factory: InformationViewModelFactory by instance()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_information)
        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        viewModel = ViewModelProvider(this, factory).get(InformationViewModel::class.java)
        viewModel.getInformationList()


        viewModel.result.observe(this, Observer {
            if (!it.error) {
                initInformationRecyclerView(it.data)
            }
        })

        informationBackIV.setOnClickListener {
            onBackPressed()
        }

    }

    fun initInformationRecyclerView(arrayList: ArrayList<InformationModel>) {
        val mAdapter = InformationAdapter().apply {
            addItems(arrayList)
        }
        informationRecyclerView.apply {
            layoutManager = LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false)
            setHasFixedSize(true)
            adapter = mAdapter
        }

    }
}