package com.siguiente.fasal.information

import android.util.Log
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasal.network.response.InformationResponse
import com.siguiente.fasal.utils.ApiException
import com.siguiente.fasal.utils.Coroutines
import com.siguiente.fasal.utils.NoInternetException

class InformationViewModel(
    val repository: InformationRepository
) : ViewModel() {

    var result = MutableLiveData<InformationResponse>()


    fun getInformationList() {
        Coroutines.main {
            try {
                val response = repository.getInformationList()
                Log.e("GetInformation -", "" + response.toString())
                result.value = response

            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }
}