package com.siguiente.fasal.kyc

import android.os.Bundle
import com.google.android.material.floatingactionbutton.FloatingActionButton
import com.google.android.material.snackbar.Snackbar
import com.google.android.material.tabs.TabLayout
import androidx.viewpager.widget.ViewPager
import androidx.appcompat.app.AppCompatActivity
import android.view.Menu
import android.view.MenuItem
import android.widget.ImageView
import com.siguiente.fasal.R
import com.siguiente.fasal.kyc.ui.main.BankDetailsFragment
import com.siguiente.fasal.kyc.ui.main.DocumentFragment
import com.siguiente.fasal.kyc.ui.main.GstFragment
import com.siguiente.fasal.kyc.ui.main.SectionsPagerAdapter
import com.siguiente.fasal.utils.PreferenceProvider
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance

class KycDetailsActivity : AppCompatActivity(),KodeinAware{
    override val kodein by kodein()
    lateinit var backAction:ImageView
    val provider: PreferenceProvider by instance()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_kyc_details)

        backAction = findViewById(R.id.kycDetailsBackIV)

        setStatePageAdapter()

        backAction.setOnClickListener {
            onBackPressed()
        }
    }

    private fun setStatePageAdapter() {
        val viewPager: ViewPager = findViewById(R.id.view_pager)
        val tabs: TabLayout = findViewById(R.id.tabs)
        val userType = provider.getValueByKey("userType")!!
        val sectionsPagerAdapter = SectionsPagerAdapter(this, supportFragmentManager)
        if (userType.equals("2")) {
            sectionsPagerAdapter.addFragment(BankDetailsFragment(), "Bank Details")
            sectionsPagerAdapter.addFragment(DocumentFragment(), "Documents")
            sectionsPagerAdapter.addFragment(GstFragment(), "Gst")
        }else{
            sectionsPagerAdapter.addFragment(BankDetailsFragment(), "Bank Details")
            sectionsPagerAdapter.addFragment(DocumentFragment(), "Documents")
        }
        viewPager.adapter = sectionsPagerAdapter
        tabs.setupWithViewPager(viewPager)

    }
}