package com.siguiente.fasal.kyc.ui.main


import android.R.attr.path
import android.app.Activity
import android.content.Intent
import android.content.pm.PackageManager
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.net.Uri
import android.os.Bundle
import android.os.Environment
import android.provider.MediaStore
import android.text.Editable
import android.text.TextWatcher
import android.util.Base64
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.Toast
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import androidx.core.content.FileProvider
import androidx.core.widget.addTextChangedListener
import androidx.databinding.DataBindingUtil
import androidx.fragment.app.Fragment
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.bumptech.glide.Glide
import com.siguiente.fasal.BuildConfig
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.BankDetailsFragmentBinding
import com.siguiente.fasal.dialog.MessageDialog
import com.siguiente.fasal.utils.PreferenceProvider
import com.siguiente.fasal.utils.toast
import kotlinx.android.synthetic.main.bank_details_fragment.*
import kotlinx.android.synthetic.main.document_fragment.*
import kotlinx.android.synthetic.main.fragment_transfer_credit_bottom_sheet.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance
import java.io.*
import java.text.SimpleDateFormat
import java.util.*
import kotlin.collections.HashMap


class BankDetailsFragment : Fragment(), KodeinAware {
    override val kodein by kodein()
    lateinit var binding: BankDetailsFragmentBinding
    var base64Image = ""
    val provider: PreferenceProvider by instance()
    val factory: BankDetailsViewModelFactory by instance()
    lateinit var currentPhotoPath: String


    companion object {
        fun newInstance() = BankDetailsFragment()
    }

    private lateinit var viewModel: BankDetailsViewModel


    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = DataBindingUtil.inflate(
            inflater,
            R.layout.bank_details_fragment,
            container,
            false
        )

        return binding.root
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProvider(this, factory).get(BankDetailsViewModel::class.java)

        viewModel.result.observe(viewLifecycleOwner, Observer {
            bankProgressBar.visibility = View.INVISIBLE
            if (!it.error!!) {
                clearTextField()
            }
            val msgDialog = MessageDialog(it.message.toString())
            msgDialog.show(parentFragmentManager, "MessageDialog")

        })
        uploadBankDetailsLL.setOnClickListener {
            selectImageDialog(101, 102)
        }

        saveBankDetailButton.setOnClickListener {
            bankProgressBar.visibility = View.VISIBLE
            saveBankDetailButton.isClickable = false
            saveBankDetailButton.isEnabled = false
            saveBankDetailButton.setBackgroundColor(resources.getColor(R.color.colorGrayTexts))
            if (validateField()) {
                bankProgressBar.visibility = View.INVISIBLE
                saveBankDetailButton.isClickable = true
                saveBankDetailButton.isEnabled = true

            } else {
                saveBankDetail()
            }

        }

    }

    private fun selectImageDialog(cameraCode: Int, galleryCode: Int) {
        val options = arrayOf<CharSequence>("Take Photo", "Choose from Gallery", "Cancel")
        val builder = androidx.appcompat.app.AlertDialog.Builder(requireContext())
        builder.setTitle("Choose your Passbook/Cheque Picture")

        builder.setItems(options) { dialog, item ->
            if (options[item] == "Take Photo") {
                val checkSelfPermission =
                    ContextCompat.checkSelfPermission(
                        requireContext(),
                        android.Manifest.permission.CAMERA
                    )
                if (checkSelfPermission != PackageManager.PERMISSION_GRANTED) {
                    ActivityCompat.requestPermissions(
                        requireActivity(),
                        arrayOf(android.Manifest.permission.CAMERA),
                        1
                    )
                } else {
                    dispatchTakePictureIntent(cameraCode)
                }

            } else if (options[item] == "Choose from Gallery") {
                val checkSelfPermission = ContextCompat.checkSelfPermission(
                    requireContext(),
                    android.Manifest.permission.WRITE_EXTERNAL_STORAGE
                )
                if (checkSelfPermission != PackageManager.PERMISSION_GRANTED) {
                    ActivityCompat.requestPermissions(
                        requireActivity(),
                        arrayOf(android.Manifest.permission.WRITE_EXTERNAL_STORAGE),
                        1
                    )
                } else {
                    val pickPhoto = Intent(
                        Intent.ACTION_PICK,
                        MediaStore.Images.Media.EXTERNAL_CONTENT_URI
                    )
                    startActivityForResult(pickPhoto, galleryCode)
                }

            } else if (options[item] == "Cancel") {
                dialog.dismiss()
            }
        }
        builder.show()

    }

    @Throws(IOException::class)
    private fun createImageFile(): File {
        val timeStamp: String = SimpleDateFormat("yyyyMMdd_HHmmss").format(Date())
        val storageDir: File? = context?.getExternalFilesDir(Environment.DIRECTORY_PICTURES)
        return File.createTempFile(
            "JPEG_${timeStamp}_", /* prefix */
            ".jpg", /* suffix */
            storageDir /* directory */
        ).apply {
            currentPhotoPath = absolutePath
        }
    }


    private fun dispatchTakePictureIntent(requestCode: Int) {
        Intent(MediaStore.ACTION_IMAGE_CAPTURE).also { takePictureIntent ->
            takePictureIntent.resolveActivity(requireActivity().packageManager)?.also {
                val photoFile: File? = try {
                    createImageFile()
                } catch (ex: IOException) {
                    null
                }
                photoFile?.also {
                    val photoURI: Uri = FileProvider.getUriForFile(
                        requireContext(),
                        BuildConfig.APPLICATION_ID + ".fileprovider",
                        it
                    )
                    takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT, photoURI)
                    startActivityForResult(takePictureIntent, requestCode)
                }
            }
        }
    }


    override fun onRequestPermissionsResult(
        requestCode: Int,
        permissions: Array<out String>,
        grantResults: IntArray
    ) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults)
        when (requestCode) {
            1 ->
                if (grantResults.isNotEmpty() && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    selectImageDialog(101, 102)
                } else {
                    Toast.makeText(context, "You denied the permission", Toast.LENGTH_SHORT).show()
                }
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        when (requestCode) {
            101 ->
                if (resultCode == Activity.RESULT_OK) {
                    val imageBitmap = data?.extras?.get("data")
                    Glide.with(this).load(currentPhotoPath).into(bankDetailsPlusIV)
                    Log.e("ImageBitmapData-", "" + imageBitmap)
                    Log.e("ImagePath-", "" + currentPhotoPath)
                    val file = File(currentPhotoPath)
                    val b = BitmapFactory.decodeStream(FileInputStream(file))
                    base64Image = toBase64(b)!!
                    Log.e("base64Image-", "" + base64Image)
                }
            102 ->
                if (resultCode == Activity.RESULT_OK) {
                    val imageUri: Uri = data?.data!!
                    Log.e("ImageUri", "" + imageUri)
                    var bitmap: Bitmap? = null
                    try {
                        bitmap =
                            getBitmap(imageUri)
                        bankDetailsPlusIV.setImageBitmap(bitmap)
                    } catch (e: IOException) {
                        e.printStackTrace()
                    }
                    base64Image = toBase64(bitmap!!)!!
                }
        }

    }

    @Throws(FileNotFoundException::class, IOException::class)
    fun getBitmap(url: Uri?): Bitmap {
        val input: InputStream? = context?.contentResolver?.openInputStream(url!!)
        val bitmap = BitmapFactory.decodeStream(input)
        input?.close()
        return bitmap
    }


    private fun toBase64(bm: Bitmap): String? {
        val baos = ByteArrayOutputStream()
        bm.compress(Bitmap.CompressFormat.JPEG, 100, baos) //bm is the bitmap object
        val b: ByteArray = baos.toByteArray()
        return Base64.encodeToString(b, Base64.DEFAULT)
    }

    private fun saveBankDetail() {
        Log.e("Base64Image-", base64Image)
        val userID = provider.getValueByKey("userID")!!
        val map: HashMap<String, String> = HashMap()
        map.put("userID", userID)
        map.put("accountNumber", accountNumberET.text.toString())
        map.put("accountHolderName", beneficiaryNameET.text.toString())
        map.put("bankName", bankNameET.text.toString())
        map.put("ifscCode", ifscCodeET.text.toString())
        map.put("passbookImage", base64Image)
        viewModel.saveBankDetail(map)
    }

    private fun validateField(): Boolean {
        var error: Boolean = false
        val pattern = Regex("^\\d{9,18}$")
        if (!pattern.containsMatchIn(accountNumberET.text.toString())) {
            error = true
            accountNumberET.error = "Enter valid account number"
        }

        if (beneficiaryNameET.text.toString().isEmpty()) {
            error = true
            beneficiaryNameET.error = "Enter account holder name"
        }

        if (bankNameET.text.toString().isEmpty()) {
            error = true
            bankNameET.error = "Enter bank name"
        }
        val ifscPattern = Regex("^[A-Za-z]{4}\\d{7}\$")
        if (!ifscPattern.containsMatchIn(ifscCodeET.text.toString())) {
            error = true
            ifscCodeET.error = "Enter valid ifsc code"
        }

        return error
    }

    private fun clearTextField() {
        saveBankDetailButton.isClickable = true
        saveBankDetailButton.isEnabled = true
        bankDetailsPlusIV.setImageResource(android.R.color.transparent);
        accountNumberET.setText("")
        beneficiaryNameET.setText("")
        bankNameET.setText("")
        ifscCodeET.setText("")
    }

}
