package com.siguiente.fasal.kyc.ui.main

import android.app.Activity
import android.content.Intent
import android.content.pm.PackageManager
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.net.Uri
import androidx.lifecycle.ViewModelProvider
import android.os.Bundle
import android.os.Environment
import android.provider.MediaStore
import android.util.Base64
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.Toast
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import androidx.core.content.FileProvider
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import com.bumptech.glide.Glide
import com.siguiente.fasal.BuildConfig
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.DocumentFragmentBinding
import com.siguiente.fasal.dialog.MessageDialog
import com.siguiente.fasal.utils.PreferenceProvider
import com.siguiente.fasal.utils.toast
import kotlinx.android.synthetic.main.bank_details_fragment.*
import kotlinx.android.synthetic.main.document_fragment.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance
import java.io.ByteArrayOutputStream
import java.io.File
import java.io.FileInputStream
import java.io.IOException
import java.text.SimpleDateFormat
import java.util.*
import kotlin.collections.HashMap

class DocumentFragment : Fragment(), KodeinAware {
    val factory: DocumentViewModelFactory by instance()
    override val kodein by kodein()
    lateinit var binding: DocumentFragmentBinding
    var base64Image = ""
    lateinit var currentPhotoPath: String
    val provider: PreferenceProvider by instance()

    companion object {
        fun newInstance() = DocumentFragment()
    }

    private lateinit var viewModel: DocumentViewModel


    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = DataBindingUtil.inflate(inflater, R.layout.document_fragment, container, false)

        return binding.root
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProvider(this, factory).get(DocumentViewModel::class.java)

        viewModel.result.observe(viewLifecycleOwner, Observer {
            documentProgressBar.visibility = View.INVISIBLE
            saveKycDocumentButton.isClickable = true
            saveKycDocumentButton.isEnabled = true
            verificationUploadIV.setImageResource(android.R.color.transparent);
            val msgDialog = MessageDialog(it.message.toString())
            msgDialog.show(parentFragmentManager, "MessageDialog")
        })

        verificationUploadLayout.setOnClickListener {
            selectImageDialog(101, 102)
        }

        saveKycDocumentButton.setOnClickListener {
            documentProgressBar.visibility = View.VISIBLE
            saveKycDocumentButton.isClickable = false
            saveKycDocumentButton.isEnabled = false
            saveKycDocument()
        }
    }


    private fun selectImageDialog(cameraCode: Int, galleryCode: Int) {
        val options = arrayOf<CharSequence>("Take Photo", "Choose from Gallery", "Cancel")
        val builder = androidx.appcompat.app.AlertDialog.Builder(requireContext())
        builder.setTitle("Choose your Document Picture")

        builder.setItems(options) { dialog, item ->
            if (options[item] == "Take Photo") {
                val checkSelfPermission =
                    ContextCompat.checkSelfPermission(
                        requireContext(),
                        android.Manifest.permission.CAMERA
                    )
                if (checkSelfPermission != PackageManager.PERMISSION_GRANTED) {
                    ActivityCompat.requestPermissions(
                        requireActivity(),
                        arrayOf(android.Manifest.permission.CAMERA),
                        1
                    )
                } else {
                    dispatchTakePictureIntent(cameraCode)
                }

            } else if (options[item] == "Choose from Gallery") {
                val checkSelfPermission = ContextCompat.checkSelfPermission(
                    requireContext(),
                    android.Manifest.permission.WRITE_EXTERNAL_STORAGE
                )
                if (checkSelfPermission != PackageManager.PERMISSION_GRANTED) {
                    ActivityCompat.requestPermissions(
                        requireActivity(),
                        arrayOf(android.Manifest.permission.WRITE_EXTERNAL_STORAGE),
                        1
                    )
                } else {
                    val pickPhoto = Intent(
                        Intent.ACTION_PICK,
                        MediaStore.Images.Media.EXTERNAL_CONTENT_URI
                    )
                    startActivityForResult(pickPhoto, galleryCode)
                }

            } else if (options[item] == "Cancel") {
                dialog.dismiss()
            }
        }
        builder.show()

    }

    @Throws(IOException::class)
    private fun createImageFile(): File {
        // Create an image file name
        val timeStamp: String = SimpleDateFormat("yyyyMMdd_HHmmss").format(Date())
        val storageDir: File? = context?.getExternalFilesDir(Environment.DIRECTORY_PICTURES)
        return File.createTempFile(
            "JPEG_${timeStamp}_", /* prefix */
            ".jpg", /* suffix */
            storageDir /* directory */
        ).apply {
            currentPhotoPath = absolutePath
        }
    }


    private fun dispatchTakePictureIntent(requestCode: Int) {
        Intent(MediaStore.ACTION_IMAGE_CAPTURE).also { takePictureIntent ->
            takePictureIntent.resolveActivity(requireActivity().packageManager)?.also {
                val photoFile: File? = try {
                    createImageFile()
                } catch (ex: IOException) {
                    null
                }
                photoFile?.also {
                    val photoURI: Uri = FileProvider.getUriForFile(
                        requireContext(),
                        BuildConfig.APPLICATION_ID + ".fileprovider",
                        it
                    )
                    takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT, photoURI)
                    startActivityForResult(takePictureIntent, requestCode)
                }
            }
        }
    }


    override fun onRequestPermissionsResult(
        requestCode: Int,
        permissions: Array<out String>,
        grantResults: IntArray
    ) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults)
        when (requestCode) {
            1 ->
                if (grantResults.isNotEmpty() && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    selectImageDialog(101, 102)
                } else {
                    Toast.makeText(context, "You denied the permission", Toast.LENGTH_SHORT).show()
                }
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        when (requestCode) {
            101 ->
                if (resultCode == Activity.RESULT_OK) {
                    val imageBitmap = data?.extras?.get("data")
                    Glide.with(this).load(currentPhotoPath).into(verificationUploadIV)
                    Log.e("ImageBitmapData-", "" + imageBitmap)
                    Log.e("ImagePath-", "" + currentPhotoPath)
                    val file = File(currentPhotoPath)
                    val b = BitmapFactory.decodeStream(FileInputStream(file))
                    base64Image = toBase64(b)!!
                    Log.e("base64Image-", "" + base64Image)
                }
            102 ->
                if (resultCode == Activity.RESULT_OK) {
                    val imageUri: Uri = data?.data!!
                    var bitmap: Bitmap? = null
                    try {
                        bitmap =
                            MediaStore.Images.Media.getBitmap(context?.contentResolver, imageUri)
                        verificationUploadIV.setImageBitmap(bitmap)
                    } catch (e: IOException) {
                        e.printStackTrace()
                    }
                    base64Image = toBase64(bitmap!!)!!
                }
        }

    }


    private fun toBase64(bm: Bitmap): String? {
        val baos = ByteArrayOutputStream()
        bm.compress(Bitmap.CompressFormat.PNG, 100, baos) //bm is the bitmap object
        val b: ByteArray = baos.toByteArray()
        return Base64.encodeToString(b, Base64.NO_WRAP)
    }

    private fun saveKycDocument() {
        val userID = provider.getValueByKey("userID")!!
        val map: HashMap<String, String> = HashMap()
        map["userID"] = userID
        map["documentName"] = documentSpinner.selectedItem.toString()
        map["documnetImg"] = base64Image
        viewModel.saveKYCDocumnet(map)
    }

}