package com.siguiente.fasal.kyc.ui.main

import android.util.Log
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasal.network.response.CommonResponse
import com.siguiente.fasal.utils.ApiException
import com.siguiente.fasal.utils.Coroutines
import com.siguiente.fasal.utils.NoInternetException

class DocumentViewModel(
    val repository: KycRepository
) : ViewModel() {

    var result = MutableLiveData<CommonResponse>()

    fun saveKYCDocumnet(field:HashMap<String,String>){
        Coroutines.main {
            try {
                val response = repository.saveKYCDocumnet(field)
                if (response.error != true) {
                    result.value = response
                    Log.e("documentResponse -", "" + response.toString())
                } else {
                    result.value = response
                    Log.e("documentResponse-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

}