package com.siguiente.fasal.kyc.ui.main

import androidx.lifecycle.ViewModelProvider
import android.os.Bundle
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.DocumentFragmentBinding
import com.siguiente.fasal.databinding.GstFragmentBinding
import com.siguiente.fasal.dialog.MessageDialog
import com.siguiente.fasal.utils.PreferenceProvider
import com.siguiente.fasal.utils.toast
import kotlinx.android.synthetic.main.bank_details_fragment.*
import kotlinx.android.synthetic.main.gst_fragment.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance

class GstFragment : Fragment(), KodeinAware {
    val factory: GstViewModelFactory by instance()
    override val kodein by kodein()
    lateinit var binding: GstFragmentBinding
    val provider: PreferenceProvider by instance()

    companion object {
        fun newInstance() = GstFragment()
    }

    private lateinit var viewModel: GstViewModel

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = DataBindingUtil.inflate(inflater, R.layout.gst_fragment, container, false)

        return binding.root
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProvider(this, factory).get(GstViewModel::class.java)
        viewModel.result.observe(viewLifecycleOwner, Observer {
            gstProgressBar.visibility=View.INVISIBLE
            val msgDialog = MessageDialog(it.message.toString())
            msgDialog.show(childFragmentManager, "MessageDialog")
        })


        saveGstButton.setOnClickListener {
            gstProgressBar.visibility=View.VISIBLE
            saveGstDetail()
        }

    }

    fun saveGstDetail() {
        val userID = provider.getValueByKey("userID")!!
        val map: HashMap<String, String> = HashMap()
        map.put("userID", userID)
        map.put("registrationName", gstRegistrationNumberET.text.toString())
        map.put("gstNumber", gstNumberET.text.toString())
        viewModel.saveGSTDetail(map)
    }

}