package com.siguiente.fasal.login.ui.login


import android.content.Intent
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import android.widget.*
import androidx.databinding.DataBindingUtil
import com.siguiente.fasal.MainActivity
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivityLoginBinding
import com.siguiente.fasal.profile.ForgotPasswordActivity
import com.siguiente.fasal.registration.UserRegistrationActivity
import com.siguiente.fasal.utils.PreferenceProvider
import com.siguiente.fasal.utils.toast
import kotlinx.android.synthetic.main.activity_login.*
import kotlinx.android.synthetic.main.activity_login.view.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance
import java.util.HashMap

class LoginActivity : AppCompatActivity(), KodeinAware {

    override val kodein by kodein()
    private lateinit var loginViewModel: LoginViewModel
    private lateinit var binding: ActivityLoginBinding
    val factory: LoginViewModelFactory by instance()
    val provider: PreferenceProvider by instance()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_login)
        supportActionBar?.hide()


        loginViewModel = ViewModelProvider(this, factory)
            .get(LoginViewModel::class.java)

        loginViewModel.loginResult.observe(this@LoginActivity, Observer {
            loginProgressBar.visibility = View.GONE
            if (!it.error!!) {
                provider.saveValueByKey("userID", it.userID.toString())
                provider.saveValueByKey("userType", "" + it.userType)
                val intent = Intent(applicationContext, MainActivity::class.java)
                intent.putExtra("ActivityTag", "Login")
                startActivity(intent)
                this.finish()
            } else {
                toast("" + it.message!!)
            }
        })

        binding.login.setOnClickListener {
            if (!username.text.isNullOrEmpty() && !password.text.isNullOrEmpty()) {
                loginProgressBar.visibility = View.VISIBLE
                userLogin()
            } else {
                toast("Field Empty")
            }
        }


        forgotPasswordTV.setOnClickListener {
            startActivity(Intent(this, ForgotPasswordActivity::class.java))
        }

        dontHaveAccountTV.setOnClickListener {
            val intent = Intent(applicationContext, UserRegistrationActivity::class.java)
            startActivity(intent)
        }

    }

    private fun userLogin() {
        val token = provider.getValueByKey("firebaseToken")
        val mobile = binding.username.text.toString().trim()
        val password = binding.password.text.toString().trim()
        val map: HashMap<String, String> = HashMap()
        map["userMobile"] = mobile
        map["userPassword"] = password
        map["firebaseToken"] = token.toString()
        loginViewModel.login(map)
    }
}
