package com.siguiente.fasal.login.ui.login

import android.util.Log
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasal.login.data.LoginRepository
import com.siguiente.fasal.network.response.CommonResponse
import com.siguiente.fasal.utils.ApiException
import com.siguiente.fasal.utils.Coroutines
import com.siguiente.fasal.utils.NoInternetException


class LoginViewModel(private val repository: LoginRepository) : ViewModel() {

     val loginResult = MutableLiveData<CommonResponse>()

    //For Verifying OTP
    fun login(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.login(field)
                loginResult.value = response
                Log.e("LoginResult",""+response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

}