package com.siguiente.fasal.my_store


import android.content.DialogInterface
import android.os.Bundle
import android.util.Log
import android.view.View
import android.widget.Spinner
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivityAddProductBinding
import com.siguiente.fasal.dialog.MessageDialog
import com.siguiente.fasal.home.HomeViewModel
import com.siguiente.fasal.home.HomeViewModelFactory
import com.siguiente.fasal.home.model.CategoryModel
import com.siguiente.fasal.my_store.adapter.SubCategorySpinnerAdapter
import com.siguiente.fasal.my_store.model.SubCategoryModel
import com.siguiente.fasal.utils.*
import kotlinx.android.synthetic.main.activity_add_product.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance


class AddProductActivity : AppCompatActivity(), KodeinAware,
    SpinnerExtensions.ItemSelectedListener {
    override val kodein by kodein()
    private lateinit var binding: ActivityAddProductBinding

    private lateinit var homeViewModel: HomeViewModel
    private val factoryHome: HomeViewModelFactory by instance()

    private lateinit var storeViewModel: MyStoreViewModel
    private val factoryStore: StoreViewModelFactory by instance()
    private var categoryID = ""
    private var subCategoryID = ""
    private var seedID = ""
    private var type = ""
    private val subCategoryArray = ArrayList<SubCategoryModel>()

    val provider: PreferenceProvider by instance()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_add_product)
        supportActionBar?.hide()
        homeViewModel = ViewModelProvider(this, factoryHome).get(HomeViewModel::class.java)
        homeViewModel.getCategories()

        storeViewModel = ViewModelProvider(this, factoryStore).get(MyStoreViewModel::class.java)

        subCategoryArray.add(
            SubCategoryModel(
                "0",
                "0",
                "No Subcategory Found",
                "",
                "",
                "",
                "",
                "",
                ""
            )
        )

        type = intent.extras!!.getString("Type", "")
        if (type == "Update") {
            addProductProgressBar.visibility = View.VISIBLE
            seedID = intent.extras!!.getString("seedID", "")
            saveSeedGrainsButton.text = getString(R.string.update)
            val map: HashMap<String, String> = HashMap()
            map["seedID"] = seedID
            storeViewModel.viewSeedsAndGrains(map)
        }

        homeViewModel.result.observe(this, Observer {
            seedCategorySpinner.setEntries(it.data)
        })

        storeViewModel.subCategoryResult.observe(this, Observer {
            if (!it.error!!)
                seedSubCategorySpinner.setSubCategoryData(it.data)
            else
                seedSubCategorySpinner.setSubCategoryData(subCategoryArray)
        })

        storeViewModel.result.observe(this, Observer {
            addProductProgressBar.visibility = View.INVISIBLE
            showConfirmationMessage(it.message.toString())
        })

        storeViewModel.viewSeedGrainsResult.observe(this, Observer {
            binding.storeViewModel = it
            quantitySpinner.setSelection(getIndex(quantitySpinner, it.quantity))
            seedGrainSizeSpinner.setSelection(getIndex(seedGrainSizeSpinner, it.seedSize))
            unitSpinner.setSelection(getIndex(unitSpinner, it.unit))
            addProductProgressBar.visibility = View.INVISIBLE
        })

        seedCategorySpinner.setItemSelectedListener(this)
        seedSubCategorySpinner.setSubItemSelectedListener(this)
        addProductBackIV.setOnClickListener {
            onBackPressed()
        }

        saveSeedGrainsButton.setOnClickListener {
            addProductProgressBar.visibility = View.VISIBLE
            saveUpdateSeedGrains()
        }

    }

    private fun saveUpdateSeedGrains() {
        val map: java.util.HashMap<String, String> = java.util.HashMap()
        val userID = provider.getValueByKey("userID")
        val name = binding.seedNameET.text.toString().trim()
        val price = binding.seedPriceET.text.toString().trim()
        val color = binding.seedsGrainColorET.text.toString().trim()
        val seedType = binding.seedDescriptionET.text.toString().trim()
        val quantity = binding.quantitySpinner.selectedItem
        val unit = binding.unitSpinner.selectedItem.toString()
        val grainSize = binding.seedGrainSizeSpinner.selectedItem.toString()

        map["userID"] = userID!!
        map["seedID"] = seedID
        map["seedsName"] = name
        map["seedColor"] = color
        map["seedSize"] = grainSize
        map["seedType"] = seedType
        map["categoryType"] = categoryID
        map["subCategoryID"] = subCategoryID
        map["quantity"] = quantity.toString()
        map["unit"] = unit
        map["price"] = price
        storeViewModel.addUpdateSeedsAndGrains(map)
    }

    private fun getIndex(spinner: Spinner, myString: String): Int {
        for (i in 0 until spinner.count) {
            if (spinner.getItemAtPosition(i).toString().equals(myString, ignoreCase = true)) {
                return i
            }
        }
        return 0
    }

    override fun onItemSelected(item: CategoryModel) {
        categoryID = item.categoryID
        Log.e("Selected Item-", "" + item.categoryID)
        val map: java.util.HashMap<String, String> = java.util.HashMap()
        map["categoryID"] = categoryID
        storeViewModel.getSubCategories(map)
    }

    override fun onSubItemSelected(item: SubCategoryModel) {
        subCategoryID = item.id
        Log.e("Selected  Sub Item-", "" + item.id)
    }


    private fun showConfirmationMessage(msg: String) {
        val builder = AlertDialog.Builder(this)
        builder.setMessage(msg)
        builder.setPositiveButton("Yes") { dialogInterface, _ ->
            dialogInterface.dismiss()
            this.finish()
        }
        val alertDialog: AlertDialog = builder.create()
        alertDialog.setCancelable(false)
        alertDialog.show()
    }
}
