package com.siguiente.fasal.my_store

import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.*
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.databinding.DataBindingUtil
import androidx.fragment.app.Fragment
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.FragmentMyStoreBinding
import com.siguiente.fasal.dialog.MessageDialog
import com.siguiente.fasal.home.HomeViewModel
import com.siguiente.fasal.home.HomeViewModelFactory
import com.siguiente.fasal.home.adapter.FarmerItemAdapter
import com.siguiente.fasal.home.adapter.ProductsListAdapter
import com.siguiente.fasal.home.model.CategoryModel
import com.siguiente.fasal.home.model.SeedsModel
import com.siguiente.fasal.my_store.adapter.StoreCategoryAdapter
import com.siguiente.fasal.my_store.model.StoreCategoryModel
import com.siguiente.fasal.utils.PreferenceProvider
import com.siguiente.fasal.utils.toast
import kotlinx.android.synthetic.main.fragment_home.*
import kotlinx.android.synthetic.main.fragment_my_store.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance

class MyStoreFragment : AppCompatActivity(), KodeinAware {
    private lateinit var storeViewModel: MyStoreViewModel
    private val factoryStore: StoreViewModelFactory by instance()
    private lateinit var myStoreViewModel: HomeViewModel
    override val kodein by kodein()
    private val factory: HomeViewModelFactory by instance()
    private lateinit var binding: FragmentMyStoreBinding
    val provider: PreferenceProvider by instance()
    var userID = ""

    override fun onStart() {
        super.onStart()
        getStoreList()
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.fragment_my_store)
        supportActionBar?.hide()
        storeListProgressBar.visibility = View.VISIBLE
        myStoreViewModel = ViewModelProvider(this, factory).get(HomeViewModel::class.java)
        storeViewModel = ViewModelProvider(this, factoryStore).get(MyStoreViewModel::class.java)

        myStoreViewModel.seedsByUserResult.observe(this, Observer {
            if (!it.error) {
                initRecyclerView(it.data)
                storeListNoDataFoundTV.visibility = View.GONE
            } else {
                storeListNoDataFoundTV.visibility = View.VISIBLE
            }
            storeListProgressBar.visibility = View.GONE
        })


        storeViewModel.result.observe(this, Observer {
            if (!it.error!!){
                val messageDialog=MessageDialog(it.message!!)
                messageDialog.show(supportFragmentManager,"DeleteMessage")
                getStoreList()
            }
        })


        myStoreBackIV.setOnClickListener {
            onBackPressed()
        }

        myStorePlusIV.setOnClickListener {
            val intent = Intent(this, AddProductActivity::class.java)
            intent.putExtra("Type", "Save")
            startActivity(intent)
        }

    }

    private fun getStoreList() {
        userID = provider.getValueByKey("userID")!!
        val map: HashMap<String, String> = HashMap()
        map["userID"] = userID
        myStoreViewModel.getSeedListsByID(map)
    }

    private fun deleteSeed(seedID: String) {
        val map: HashMap<String, String> = HashMap()
        map["seedID"] = seedID
        storeViewModel.deleteSeedsAndGrains(map)
    }

    private fun initRecyclerView(productsItem: ArrayList<SeedsModel>) {
        val mAdapter = ProductsListAdapter("Store").apply {
            addItems(productsItem)
        }

        myStoreCategoryRV.apply {
            layoutManager = LinearLayoutManager(context)
            setHasFixedSize(true)
            adapter = mAdapter
        }

        mAdapter.listener = { view, item, position ->
            if (view.tag.equals("deleteSeed")) {
                showConfirmationMessage(item.seedID)
            } else {
                val intent = Intent(this, AddProductActivity::class.java)
                intent.putExtra("Type", "Update")
                intent.putExtra("seedID", productsItem[position].seedID)
                startActivity(intent)
            }
        }

    }

    private fun showConfirmationMessage(productID: String) {
        val builder = AlertDialog.Builder(this)
        builder.setMessage("Are you sure you want to delete?")
        builder.setPositiveButton("Yes") { dialogInterface, _ ->
            deleteSeed(productID)
            dialogInterface.dismiss()

        }
        builder.setNegativeButton("No") { dialogInterface, _ ->
            dialogInterface.dismiss()
        }
        val alertDialog: AlertDialog = builder.create()
        alertDialog.setCancelable(false)
        alertDialog.show()
    }


}