package com.siguiente.fasal.my_store

import android.util.Log
import androidx.databinding.ObservableField
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasal.home.model.CategoryModel
import com.siguiente.fasal.network.response.*
import com.siguiente.fasal.utils.ApiException
import com.siguiente.fasal.utils.Coroutines
import com.siguiente.fasal.utils.NoInternetException

class MyStoreViewModel(
    var repository: StoreRepository
) : ViewModel() {

    val result = MutableLiveData<CommonResponse>()
    val viewSeedGrainsResult = MutableLiveData<SeedGrainsResponse>()
    val subCategoryResult = MutableLiveData<SubCategoryResponse>()
    val seedByCategoryResult = MutableLiveData<SeedResponse>()


    fun addUpdateSeedsAndGrains(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.addUpdateSeedsAndGrains(field)
                Log.e("GetProfile s -", "" + response.toString())
                if (response.error != true) {
                    result.value = response
                } else {
                    result.value = response

                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun viewSeedsAndGrains(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.viewSeedsAndGrains(field)
                if (response.error != true) {
                    viewSeedGrainsResult.value = response
                    Log.e("updateProfile s -", "" + response.toString())
                } else {
                    viewSeedGrainsResult.value = response
                    Log.e("updateProfile e-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }


    fun deleteSeedsAndGrains(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.deleteSeedsAndGrains(field)
                if (response.error != true) {
                    result.value = response
                    Log.e("updateProfile s -", "" + response.toString())
                } else {
                    result.value = response
                    Log.e("updateProfile e-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }


    fun getSubCategories(field: HashMap<String, String>) {
        Coroutines.main {
            try {
                val response = repository.getSubCategories(field)
                if (response.error != true) {
                    subCategoryResult.value = response
                    Log.e("subcategory s -", "" + response.toString())
                } else {
                    subCategoryResult.value = response
                    Log.e("subcategory e-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun getSeedListByCategory(field: HashMap<String, String>) {
        Coroutines.main {
            try {
                val response = repository.getSeedListByCategory(field)
                if (!response.error) {
                    seedByCategoryResult.value = response
                    Log.e("seedbyCategory s -", "" + response.toString())
                } else {
                    seedByCategoryResult.value = response
                    Log.e("seedByCategory e-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

}