package com.siguiente.fasal.my_store

import com.siguiente.fasal.network.MyApi
import com.siguiente.fasal.network.SafeApiRequest
import com.siguiente.fasal.network.response.CommonResponse
import com.siguiente.fasal.network.response.SeedGrainsResponse
import com.siguiente.fasal.network.response.SeedResponse
import com.siguiente.fasal.network.response.SubCategoryResponse


class StoreRepository(
    private val api: MyApi
) : SafeApiRequest() {

    suspend fun addUpdateSeedsAndGrains(filed: Map<String, String>): CommonResponse {
        return apiRequest { api.addUpdateSeedGrain(filed) }
    }

    suspend fun viewSeedsAndGrains(filed: Map<String, String>): SeedGrainsResponse {
        return apiRequest { api.viewSeedGrain(filed) }
    }

    suspend fun deleteSeedsAndGrains(filed: Map<String, String>): CommonResponse {
        return apiRequest { api.deleteSeedGrain(filed) }
    }

    suspend fun getSubCategories(filed: HashMap<String, String>): SubCategoryResponse {
        return apiRequest { api.getSubCategories(filed) }
    }

    suspend fun getSeedListByCategory(filed: HashMap<String, String>): SeedResponse {
        return apiRequest { api.getSeedListByCategory(filed) }
    }

}