package com.siguiente.fasal.my_store.adapter


import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.StoreCategoryItemDesignBinding
import com.siguiente.fasal.home.model.CategoryModel
import com.siguiente.fasal.utils.BaseRecyclerViewAdapter


class StoreCategoryAdapter: BaseRecyclerViewAdapter<CategoryModel, StoreCategoryItemDesignBinding>() {
    override fun getLayout() = R.layout.store_category_item_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<StoreCategoryItemDesignBinding>,
        position: Int
    ) {
        holder.binding.categoryModel = items[position]
        holder.binding.root.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

    }

}