package com.siguiente.fasal.my_store.adapter

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.ArrayAdapter
import android.widget.TextView
import com.siguiente.fasal.my_store.model.SubCategoryModel

class SubCategorySpinnerAdapter(context: Context, textViewResourceId: Int, private val values: ArrayList<SubCategoryModel>) : ArrayAdapter<SubCategoryModel>(context, textViewResourceId, values) {

    override fun getCount() = values.size
    override fun getItem(position: Int) = values[position]
    override fun getItemId(position: Int) = position.toLong()

    override fun getView(position: Int, convertView: View?, parent: ViewGroup): View {
        val label = super.getView(position, convertView, parent) as TextView
        label.text = values[position].subCategoryName
        return label
    }

    override fun getDropDownView(position: Int, convertView: View?, parent: ViewGroup): View {
        val label = super.getDropDownView(position, convertView, parent) as TextView
        label.text = values[position].subCategoryName
        return label
    }
}