package com.siguiente.fasal.network


import com.siguiente.fasal.network.response.*
import okhttp3.OkHttpClient
import org.json.JSONObject
import retrofit2.Response
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.http.*
import java.util.concurrent.TimeUnit

@JvmSuppressWildcards
interface MyApi {

    @POST("login.php")
    suspend fun userLogin(@Body fieldName: Map<String, String>): Response<CommonResponse>

    @GET("getShopTypeList.php")
    suspend fun getShopTypeList(): Response<ShopTypeResponse>

    @POST("registration.php")
    suspend fun userRegistration(@Body filedName: Map<String, String>): Response<CommonResponse>

    @POST("verifyMobile.php")
    suspend fun verifyMobile(@Body fieldName: Map<String, String>): Response<VerifyMobileResponse>

    @POST("verifyOTP.php")
    suspend fun verifyOTP(@Body fieldName: Map<String,Any>): Response<CommonResponse>

    @POST("getUserProfile.php")
    suspend fun getUserProfile(@Body fieldName: Map<String, String>): Response<ProfileResponse>

    @POST("updateUserProfile.php")
    suspend fun updateUserProfile(@Body fieldName: Map<String, String>): Response<CommonResponse>

    @GET("getCategories.php")
    suspend fun getCategories(): Response<CategoryResponse>

    @GET("getStories.php")
    suspend fun getStories(): Response<StoriesResponse>

    @GET("getBanner.php")
    suspend fun getBanner(): Response<BannerResponse>

    @POST("addUpdateSeedGrain.php")
    suspend fun addUpdateSeedGrain(@Body fieldName: Map<String, String>): Response<CommonResponse>

    @POST("viewSeedGrain.php")
    suspend fun viewSeedGrain(@Body fieldName: Map<String, String>): Response<SeedGrainsResponse>

    @POST("deleteSeedGrain.php")
    suspend fun deleteSeedGrain(@Body fieldName: Map<String, String>): Response<CommonResponse>

    @POST("transferCredit.php")
    suspend fun transferCredit(@Body field:HashMap<String,String>): Response<CommonResponse>

    @POST("verifyShop.php")
    suspend fun verifyShop(@Body map:HashMap<String,String>): Response<VerifyShopResponse>

    @POST("sendOTP.php")
    suspend fun sendTransactionOTP(@Body map:HashMap<String,String>): Response<VerifyMobileResponse>

    @POST("getUserSeedList.php")
    suspend fun getUserSeedList(@Body map:HashMap<String,String>): Response<SeedResponse>

    @POST("getSeedListByCategory.php")
    suspend fun getSeedListByCategory(@Body map:HashMap<String,String>): Response<SeedResponse>

    @GET("getAllSeedList.php")
    suspend fun getAllSeedList(): Response<SeedResponse>

    @POST("getAllShopList.php")
    suspend fun getAllShopList(@Body map:HashMap<String,String>): Response<ShopResponse>

    @POST("getTransferCreditHistory.php")
    suspend fun getTransferCreditHistory(@Body map:Map<String,String>): Response<TransactionHistoryResponse>

    @POST("getPayCreditHistory.php")
    suspend fun getPayCreditHistory(@Body map:HashMap<String,String>): Response<PaymentHistoryResponse>

    @POST("getRedeemCreditHistory.php")
    suspend fun getRedeemCreditHistory(@Body map:HashMap<String,String>): Response<PaymentHistoryResponse>

    @POST("getCashRequestHistory.php")
    suspend fun getCashRequestHistory(@Body map:HashMap<String,String>): Response<PaymentHistoryResponse>

    @POST("getCreditReceivedHistory.php")
    suspend fun getCreditReceivedHistory(@Body map:HashMap<String,String>): Response<TransactionHistoryResponse>

    @POST("redeemCredit.php")
    suspend fun redeemCredit(@Body map:HashMap<String,String>): Response<CommonResponse>

    @POST("requestForCash.php")
    suspend fun requestForCash(@Body map:HashMap<String,String>): Response<CommonResponse>

    @POST("requestSample.php")
    suspend fun requestSample(@Body map:HashMap<String,String>): Response<CommonResponse>

    @POST("requestSampleHistory.php")
    suspend fun requestSampleHistory(@Body map:HashMap<String,String>): Response<RequestSampleResponse>

    @POST("saveBankDetail.php")
    suspend fun saveBankDetail(@Body map:HashMap<String,String>): Response<CommonResponse>

    @POST("saveKYCDocumnet.php")
    suspend fun saveKYCDocumnet(@Body map:HashMap<String,String>): Response<CommonResponse>

    @POST("saveGSTDetail.php")
    suspend fun saveGSTDetail(@Body map:HashMap<String,String>): Response<CommonResponse>

    @POST("getSubCategories.php")
    suspend fun getSubCategories(@Body map:HashMap<String,String>): Response<SubCategoryResponse>

    @GET("getServiceList.php")
    suspend fun getServices(): Response<ServiceResponse>

    @POST("getServiceRequestList.php")
    suspend fun getServiceRequestList(@Body map:HashMap<String,String>): Response<ServiceRequestListResponse>

    @GET("getInformationList.php")
    suspend fun getInformationList(): Response<InformationResponse>

    @GET("getPolicy.php")
    suspend fun getPolicies(): Response<PoliciesResponse>

    @POST("serviceRequest.php")
    suspend fun sendServiceRequest(@Body map:HashMap<String,String>): Response<CommonResponse>

    @POST("sendServicePayment.php")
    suspend fun sendServicePayment(@Body map:HashMap<String,String>): Response<CommonResponse>

    @POST("changePassword.php")
    suspend fun changePassword(@Body map:Map<String,String>): Response<CommonResponse>

    @POST("forgotPassword.php")
    suspend fun forgotPassword(@Body map:Map<String,String>): Response<CommonResponse>

    @POST("resetPassword.php")
    suspend fun resetPassword(@Body map:Map<String,String>): Response<CommonResponse>

    @POST("viewServiceRequestDetail.php")
    suspend fun viewServiceRequestDetail(@Body fieldName: Map<String, String>): Response<ViewQuestionResponse>

    @POST("getServiceRequestReply.php")
    suspend fun getServiceRequestReply(@Body fieldName: Map<String, String>): Response<AnswerResponse>

    @POST("getDistrictList.php")
    suspend fun getDistrictList(@Body fieldName: Map<String, String>): Response<DistrictResponse>

    @POST("saveProfilePhoto.php")
    suspend fun saveProfilePhoto(@Body fieldName: Map<String, String>): Response<CommonResponse>

    @POST("payCredit.php")
    suspend fun payCredit(@Body fieldName: Map<String, String>): Response<CommonResponse>



    companion object {
        operator fun invoke(
            networkConnectionInterceptor: NetworkConnectionInterceptor
        ): MyApi {

            val okkHttpclient = OkHttpClient.Builder()
                .addInterceptor(networkConnectionInterceptor)
                .connectTimeout(30000, TimeUnit.MILLISECONDS)
                .readTimeout(30000, TimeUnit.MILLISECONDS)
                .writeTimeout(30000, TimeUnit.MILLISECONDS)
                .build()

            return Retrofit.Builder()
                .client(okkHttpclient)
                .baseUrl("https://siguientesoft.com/kishan/api/user/")
                .addConverterFactory(GsonConverterFactory.create())
                .build()
                .create(MyApi::class.java)
        }
    }

}

