package com.siguiente.fasal.news

import android.content.Intent
import androidx.lifecycle.ViewModelProvider
import android.os.Bundle
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.recyclerview.widget.LinearLayoutManager
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.StoriesFragmentBinding
import com.siguiente.fasal.home.HomeViewModelFactory
import com.siguiente.fasal.interfaces.PlayerStateCallback
import com.siguiente.fasal.news.adapter.StoriesItem
import com.siguiente.fasal.utils.Coroutines
import com.xwray.groupie.GroupAdapter
import com.xwray.groupie.ViewHolder
import kotlinx.android.synthetic.main.stories_fragment.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance

class StoriesFragment : Fragment(), KodeinAware {

    lateinit var binding: StoriesFragmentBinding
    override val kodein by kodein()

    private val factory: StoriesViewModelFactory by instance()

    companion object {
        fun newInstance() = StoriesFragment()
    }

    private lateinit var viewModel: StoriesViewModel

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = DataBindingUtil.inflate(inflater, R.layout.stories_fragment, container, false)
        return binding.root
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProvider(this, factory).get(StoriesViewModel::class.java)
        binding.lifecycleOwner = this
        binding.viewModel = viewModel
        binding.executePendingBindings()
        viewModel.getStories()


        viewModel.result.observe(viewLifecycleOwner, Observer {
            initRecyclerView(it.data.toQuoteItem())
        })

    }

    private fun initRecyclerView(quoteItem: List<StoriesItem>) {
        val mAdapter = GroupAdapter<ViewHolder>().apply {
            addAll(quoteItem)
        }

        storiesRecyclerView.apply {
            layoutManager = LinearLayoutManager(context)
            setHasFixedSize(true)
            adapter = mAdapter
        }


    }

    private fun List<Stories>.toQuoteItem(): List<StoriesItem> {
        return this.map {
            StoriesItem(it,requireContext())
        }
    }

}