package com.siguiente.fasal.news

import android.util.Log
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasal.network.response.CategoryResponse
import com.siguiente.fasal.network.response.StoriesResponse
import com.siguiente.fasal.utils.ApiException
import com.siguiente.fasal.utils.Coroutines
import com.siguiente.fasal.utils.NoInternetException
import com.siguiente.fasal.utils.lazyDeferred

class StoriesViewModel(var repository: StoriesRepository) : ViewModel() {

    var result = MutableLiveData<StoriesResponse>()

    //For Getting Category
    fun getStories() {
        Coroutines.main {
            try {
                val response = repository.getStories()
                if (response.error != true) {
                    result.value = response
                    Log.e("StoriesResponse -", "" + response.toString())
                } else {
                    result.value = response
                    Log.e("StoriesResponse-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }
}