package com.siguiente.fasal.news.adapter

import android.content.Context
import android.content.Intent
import android.graphics.Bitmap
import android.os.Build
import android.util.Log
import android.view.View
import androidx.annotation.RequiresApi
import com.google.android.exoplayer2.Player
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ItemVideoBinding
import com.siguiente.fasal.interfaces.PlayerStateCallback
import com.siguiente.fasal.news.PlayerActivity
import com.siguiente.fasal.news.Stories
import com.siguiente.fasal.utils.createImage
import com.xwray.groupie.databinding.BindableItem
import kotlinx.android.synthetic.main.fragment_profile.*
import kotlin.coroutines.coroutineContext


class StoriesItem(
    private val quote: Stories, val context: Context
) : BindableItem<ItemVideoBinding>() {

    override fun getLayout() = R.layout.item_video

    @RequiresApi(Build.VERSION_CODES.M)
    override fun bind(viewBinding: ItemVideoBinding, position: Int) {
        val type = quote.storyType
        Log.e("type-", type)
        viewBinding.setStories(quote)
        if (type.equals("Video")) {
            viewBinding.playButton.visibility = View.VISIBLE
            viewBinding.videoTimerLayout.visibility = View.VISIBLE
            viewBinding.storiesImageIV.setOnClickListener {
                val intent = Intent(context, PlayerActivity::class.java)
                intent.putExtra("VideoUrl", quote.url)
                context.startActivity(intent)
            }

        } else {
            viewBinding.playButton.visibility = View.GONE
            viewBinding.videoTimerLayout.visibility = View.GONE
        }


    }

}