package com.siguiente.fasal.order

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivityOrderBinding
import com.siguiente.fasal.home.RequestViewModel
import com.siguiente.fasal.home.RequestViewModelFactory
import com.siguiente.fasal.home.adapter.FarmerItemAdapter
import com.siguiente.fasal.home.model.CategoryModel
import com.siguiente.fasal.home.model.RequestSampleModel
import com.siguiente.fasal.utils.PreferenceProvider
import com.siguiente.fasal.utils.toast
import kotlinx.android.synthetic.main.activity_order.*
import kotlinx.android.synthetic.main.fragment_home.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance

class OrderActivity : AppCompatActivity(), KodeinAware {
    override val kodein by kodein()
    lateinit var binding: ActivityOrderBinding
    val provider: PreferenceProvider by instance()
    val factory: RequestViewModelFactory by instance()
    private lateinit var viewModel: RequestViewModel

    var userID = ""

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_order)

        viewModel = ViewModelProvider(this, factory).get(RequestViewModel::class.java)
        userID = provider.getValueByKey("userID")!!
        val map: HashMap<String, String> = HashMap()
        map.put("userID", userID)
        viewModel.requestSampleList(map)

        viewModel.requestSampleListResponse.observe(this, Observer {
            if (!it.error)
                initRecyclerView(it.data)
        })


        orderBackIV.setOnClickListener {
            onBackPressed()
        }
    }

    private fun initRecyclerView(productsItem: ArrayList<RequestSampleModel>) {
        val mAdapter = OrderAdapter().apply {
            addItems(productsItem)
        }

        orderRecyclerView.apply {
            layoutManager = LinearLayoutManager(context)
            setHasFixedSize(true)
            adapter = mAdapter
        }

    }

}